package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpoint.model.primitives.__string
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class EventCondition(
    dimensions: Optional[zio.aws.pinpoint.model.EventDimensions] =
      Optional.Absent,
    messageActivity: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.EventCondition = {
    import EventCondition.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.EventCondition
      .builder()
      .optionallyWith(dimensions.map(value => value.buildAwsValue()))(
        _.dimensions
      )
      .optionallyWith(messageActivity.map(value => value: java.lang.String))(
        _.messageActivity
      )
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.EventCondition.ReadOnly =
    zio.aws.pinpoint.model.EventCondition.wrap(buildAwsValue())
}
object EventCondition {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.EventCondition
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.EventCondition =
      zio.aws.pinpoint.model.EventCondition(
        dimensions.map(value => value.asEditable),
        messageActivity.map(value => value)
      )
    def dimensions: Optional[zio.aws.pinpoint.model.EventDimensions.ReadOnly]
    def messageActivity: Optional[__string]
    def getDimensions
        : ZIO[Any, AwsError, zio.aws.pinpoint.model.EventDimensions.ReadOnly] =
      AwsError.unwrapOptionField("dimensions", dimensions)
    def getMessageActivity: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("messageActivity", messageActivity)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.EventCondition
  ) extends zio.aws.pinpoint.model.EventCondition.ReadOnly {
    override val dimensions
        : Optional[zio.aws.pinpoint.model.EventDimensions.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dimensions())
        .map(value => zio.aws.pinpoint.model.EventDimensions.wrap(value))
    override val messageActivity: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.messageActivity())
      .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.EventCondition
  ): zio.aws.pinpoint.model.EventCondition.ReadOnly = new Wrapper(impl)
}
