package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.pinpoint.model.primitives.__string
import scala.jdk.CollectionConverters.*
final case class EventsBatch(
    endpoint: zio.aws.pinpoint.model.PublicEndpoint,
    events: Map[__string, zio.aws.pinpoint.model.Event]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.EventsBatch = {
    import EventsBatch.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.EventsBatch
      .builder()
      .endpoint(endpoint.buildAwsValue())
      .events(
        events
          .map({ case (key, value) =>
            (key: java.lang.String) -> value.buildAwsValue()
          })
          .asJava
      )
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.EventsBatch.ReadOnly =
    zio.aws.pinpoint.model.EventsBatch.wrap(buildAwsValue())
}
object EventsBatch {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.EventsBatch
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.EventsBatch =
      zio.aws.pinpoint.model.EventsBatch(
        endpoint.asEditable,
        events.map({ case (key, value) =>
          key -> value.asEditable
        })
      )
    def endpoint: zio.aws.pinpoint.model.PublicEndpoint.ReadOnly
    def events: Map[__string, zio.aws.pinpoint.model.Event.ReadOnly]
    def getEndpoint
        : ZIO[Any, Nothing, zio.aws.pinpoint.model.PublicEndpoint.ReadOnly] =
      ZIO.succeed(endpoint)
    def getEvents: ZIO[Any, Nothing, Map[
      __string,
      zio.aws.pinpoint.model.Event.ReadOnly
    ]] = ZIO.succeed(events)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.EventsBatch
  ) extends zio.aws.pinpoint.model.EventsBatch.ReadOnly {
    override val endpoint: zio.aws.pinpoint.model.PublicEndpoint.ReadOnly =
      zio.aws.pinpoint.model.PublicEndpoint.wrap(impl.endpoint())
    override val events: Map[__string, zio.aws.pinpoint.model.Event.ReadOnly] =
      impl
        .events()
        .asScala
        .map({ case (key, value) =>
          (key: __string) -> zio.aws.pinpoint.model.Event.wrap(value)
        })
        .toMap
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.EventsBatch
  ): zio.aws.pinpoint.model.EventsBatch.ReadOnly = new Wrapper(impl)
}
