package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetSegmentResponse(
    segmentResponse: zio.aws.pinpoint.model.SegmentResponse
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.GetSegmentResponse = {
    import GetSegmentResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.GetSegmentResponse
      .builder()
      .segmentResponse(segmentResponse.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.GetSegmentResponse.ReadOnly =
    zio.aws.pinpoint.model.GetSegmentResponse.wrap(buildAwsValue())
}
object GetSegmentResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.GetSegmentResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.GetSegmentResponse =
      zio.aws.pinpoint.model.GetSegmentResponse(segmentResponse.asEditable)
    def segmentResponse: zio.aws.pinpoint.model.SegmentResponse.ReadOnly
    def getSegmentResponse
        : ZIO[Any, Nothing, zio.aws.pinpoint.model.SegmentResponse.ReadOnly] =
      ZIO.succeed(segmentResponse)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.GetSegmentResponse
  ) extends zio.aws.pinpoint.model.GetSegmentResponse.ReadOnly {
    override val segmentResponse
        : zio.aws.pinpoint.model.SegmentResponse.ReadOnly =
      zio.aws.pinpoint.model.SegmentResponse.wrap(impl.segmentResponse())
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.GetSegmentResponse
  ): zio.aws.pinpoint.model.GetSegmentResponse.ReadOnly = new Wrapper(impl)
}
