package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetSegmentVersionResponse(
    segmentResponse: zio.aws.pinpoint.model.SegmentResponse
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.GetSegmentVersionResponse = {
    import GetSegmentVersionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.GetSegmentVersionResponse
      .builder()
      .segmentResponse(segmentResponse.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.GetSegmentVersionResponse.ReadOnly =
    zio.aws.pinpoint.model.GetSegmentVersionResponse.wrap(buildAwsValue())
}
object GetSegmentVersionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.GetSegmentVersionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.GetSegmentVersionResponse =
      zio.aws.pinpoint.model
        .GetSegmentVersionResponse(segmentResponse.asEditable)
    def segmentResponse: zio.aws.pinpoint.model.SegmentResponse.ReadOnly
    def getSegmentResponse
        : ZIO[Any, Nothing, zio.aws.pinpoint.model.SegmentResponse.ReadOnly] =
      ZIO.succeed(segmentResponse)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.GetSegmentVersionResponse
  ) extends zio.aws.pinpoint.model.GetSegmentVersionResponse.ReadOnly {
    override val segmentResponse
        : zio.aws.pinpoint.model.SegmentResponse.ReadOnly =
      zio.aws.pinpoint.model.SegmentResponse.wrap(impl.segmentResponse())
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.GetSegmentVersionResponse
  ): zio.aws.pinpoint.model.GetSegmentVersionResponse.ReadOnly = new Wrapper(
    impl
  )
}
