package zio.aws.pinpoint.model
import zio.prelude.data.Optional
import zio.aws.pinpoint.model.primitives.{__integer, __string}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class HoldoutActivity(
    nextActivity: Optional[__string] = Optional.Absent,
    percentage: __integer
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.HoldoutActivity = {
    import HoldoutActivity.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.HoldoutActivity
      .builder()
      .optionallyWith(nextActivity.map(value => value: java.lang.String))(
        _.nextActivity
      )
      .percentage(percentage: Integer)
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.HoldoutActivity.ReadOnly =
    zio.aws.pinpoint.model.HoldoutActivity.wrap(buildAwsValue())
}
object HoldoutActivity {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.HoldoutActivity
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.HoldoutActivity =
      zio.aws.pinpoint.model
        .HoldoutActivity(nextActivity.map(value => value), percentage)
    def nextActivity: Optional[__string]
    def percentage: __integer
    def getNextActivity: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("nextActivity", nextActivity)
    def getPercentage: ZIO[Any, Nothing, __integer] = ZIO.succeed(percentage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.HoldoutActivity
  ) extends zio.aws.pinpoint.model.HoldoutActivity.ReadOnly {
    override val nextActivity: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.nextActivity())
      .map(value => value: __string)
    override val percentage: __integer = impl.percentage(): __integer
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.HoldoutActivity
  ): zio.aws.pinpoint.model.HoldoutActivity.ReadOnly = new Wrapper(impl)
}
