package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpoint.model.primitives.{__string, __boolean}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ImportJobResource(
    defineSegment: Optional[__boolean] = Optional.Absent,
    externalId: Optional[__string] = Optional.Absent,
    format: zio.aws.pinpoint.model.Format,
    registerEndpoints: Optional[__boolean] = Optional.Absent,
    roleArn: __string,
    s3Url: __string,
    segmentId: Optional[__string] = Optional.Absent,
    segmentName: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.ImportJobResource = {
    import ImportJobResource.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.ImportJobResource
      .builder()
      .optionallyWith(defineSegment.map(value => value: java.lang.Boolean))(
        _.defineSegment
      )
      .optionallyWith(externalId.map(value => value: java.lang.String))(
        _.externalId
      )
      .format(format.unwrap)
      .optionallyWith(registerEndpoints.map(value => value: java.lang.Boolean))(
        _.registerEndpoints
      )
      .roleArn(roleArn: java.lang.String)
      .s3Url(s3Url: java.lang.String)
      .optionallyWith(segmentId.map(value => value: java.lang.String))(
        _.segmentId
      )
      .optionallyWith(segmentName.map(value => value: java.lang.String))(
        _.segmentName
      )
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.ImportJobResource.ReadOnly =
    zio.aws.pinpoint.model.ImportJobResource.wrap(buildAwsValue())
}
object ImportJobResource {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.ImportJobResource
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.ImportJobResource =
      zio.aws.pinpoint.model.ImportJobResource(
        defineSegment.map(value => value),
        externalId.map(value => value),
        format,
        registerEndpoints.map(value => value),
        roleArn,
        s3Url,
        segmentId.map(value => value),
        segmentName.map(value => value)
      )
    def defineSegment: Optional[__boolean]
    def externalId: Optional[__string]
    def format: zio.aws.pinpoint.model.Format
    def registerEndpoints: Optional[__boolean]
    def roleArn: __string
    def s3Url: __string
    def segmentId: Optional[__string]
    def segmentName: Optional[__string]
    def getDefineSegment: ZIO[Any, AwsError, __boolean] =
      AwsError.unwrapOptionField("defineSegment", defineSegment)
    def getExternalId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("externalId", externalId)
    def getFormat: ZIO[Any, Nothing, zio.aws.pinpoint.model.Format] =
      ZIO.succeed(format)
    def getRegisterEndpoints: ZIO[Any, AwsError, __boolean] =
      AwsError.unwrapOptionField("registerEndpoints", registerEndpoints)
    def getRoleArn: ZIO[Any, Nothing, __string] = ZIO.succeed(roleArn)
    def getS3Url: ZIO[Any, Nothing, __string] = ZIO.succeed(s3Url)
    def getSegmentId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("segmentId", segmentId)
    def getSegmentName: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("segmentName", segmentName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.ImportJobResource
  ) extends zio.aws.pinpoint.model.ImportJobResource.ReadOnly {
    override val defineSegment: Optional[__boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.defineSegment())
      .map(value => value: __boolean)
    override val externalId: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.externalId())
      .map(value => value: __string)
    override val format: zio.aws.pinpoint.model.Format =
      zio.aws.pinpoint.model.Format.wrap(impl.format())
    override val registerEndpoints: Optional[__boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.registerEndpoints())
      .map(value => value: __boolean)
    override val roleArn: __string = impl.roleArn(): __string
    override val s3Url: __string = impl.s3Url(): __string
    override val segmentId: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.segmentId())
      .map(value => value: __string)
    override val segmentName: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.segmentName())
      .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.ImportJobResource
  ): zio.aws.pinpoint.model.ImportJobResource.ReadOnly = new Wrapper(impl)
}
