package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpoint.model.primitives.__string
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class InAppMessageContent(
    backgroundColor: Optional[__string] = Optional.Absent,
    bodyConfig: Optional[zio.aws.pinpoint.model.InAppMessageBodyConfig] =
      Optional.Absent,
    headerConfig: Optional[zio.aws.pinpoint.model.InAppMessageHeaderConfig] =
      Optional.Absent,
    imageUrl: Optional[__string] = Optional.Absent,
    primaryBtn: Optional[zio.aws.pinpoint.model.InAppMessageButton] =
      Optional.Absent,
    secondaryBtn: Optional[zio.aws.pinpoint.model.InAppMessageButton] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.InAppMessageContent = {
    import InAppMessageContent.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.InAppMessageContent
      .builder()
      .optionallyWith(backgroundColor.map(value => value: java.lang.String))(
        _.backgroundColor
      )
      .optionallyWith(bodyConfig.map(value => value.buildAwsValue()))(
        _.bodyConfig
      )
      .optionallyWith(headerConfig.map(value => value.buildAwsValue()))(
        _.headerConfig
      )
      .optionallyWith(imageUrl.map(value => value: java.lang.String))(
        _.imageUrl
      )
      .optionallyWith(primaryBtn.map(value => value.buildAwsValue()))(
        _.primaryBtn
      )
      .optionallyWith(secondaryBtn.map(value => value.buildAwsValue()))(
        _.secondaryBtn
      )
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.InAppMessageContent.ReadOnly =
    zio.aws.pinpoint.model.InAppMessageContent.wrap(buildAwsValue())
}
object InAppMessageContent {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.InAppMessageContent
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.InAppMessageContent =
      zio.aws.pinpoint.model.InAppMessageContent(
        backgroundColor.map(value => value),
        bodyConfig.map(value => value.asEditable),
        headerConfig.map(value => value.asEditable),
        imageUrl.map(value => value),
        primaryBtn.map(value => value.asEditable),
        secondaryBtn.map(value => value.asEditable)
      )
    def backgroundColor: Optional[__string]
    def bodyConfig
        : Optional[zio.aws.pinpoint.model.InAppMessageBodyConfig.ReadOnly]
    def headerConfig
        : Optional[zio.aws.pinpoint.model.InAppMessageHeaderConfig.ReadOnly]
    def imageUrl: Optional[__string]
    def primaryBtn: Optional[zio.aws.pinpoint.model.InAppMessageButton.ReadOnly]
    def secondaryBtn
        : Optional[zio.aws.pinpoint.model.InAppMessageButton.ReadOnly]
    def getBackgroundColor: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("backgroundColor", backgroundColor)
    def getBodyConfig: ZIO[
      Any,
      AwsError,
      zio.aws.pinpoint.model.InAppMessageBodyConfig.ReadOnly
    ] = AwsError.unwrapOptionField("bodyConfig", bodyConfig)
    def getHeaderConfig: ZIO[
      Any,
      AwsError,
      zio.aws.pinpoint.model.InAppMessageHeaderConfig.ReadOnly
    ] = AwsError.unwrapOptionField("headerConfig", headerConfig)
    def getImageUrl: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("imageUrl", imageUrl)
    def getPrimaryBtn: ZIO[
      Any,
      AwsError,
      zio.aws.pinpoint.model.InAppMessageButton.ReadOnly
    ] = AwsError.unwrapOptionField("primaryBtn", primaryBtn)
    def getSecondaryBtn: ZIO[
      Any,
      AwsError,
      zio.aws.pinpoint.model.InAppMessageButton.ReadOnly
    ] = AwsError.unwrapOptionField("secondaryBtn", secondaryBtn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.InAppMessageContent
  ) extends zio.aws.pinpoint.model.InAppMessageContent.ReadOnly {
    override val backgroundColor: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.backgroundColor())
      .map(value => value: __string)
    override val bodyConfig
        : Optional[zio.aws.pinpoint.model.InAppMessageBodyConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.bodyConfig())
        .map(value => zio.aws.pinpoint.model.InAppMessageBodyConfig.wrap(value))
    override val headerConfig
        : Optional[zio.aws.pinpoint.model.InAppMessageHeaderConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.headerConfig())
        .map(value =>
          zio.aws.pinpoint.model.InAppMessageHeaderConfig.wrap(value)
        )
    override val imageUrl: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.imageUrl())
      .map(value => value: __string)
    override val primaryBtn
        : Optional[zio.aws.pinpoint.model.InAppMessageButton.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.primaryBtn())
        .map(value => zio.aws.pinpoint.model.InAppMessageButton.wrap(value))
    override val secondaryBtn
        : Optional[zio.aws.pinpoint.model.InAppMessageButton.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.secondaryBtn())
        .map(value => zio.aws.pinpoint.model.InAppMessageButton.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.InAppMessageContent
  ): zio.aws.pinpoint.model.InAppMessageContent.ReadOnly = new Wrapper(impl)
}
