package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class InAppMessagesResponse(
    inAppMessageCampaigns: Optional[
      Iterable[zio.aws.pinpoint.model.InAppMessageCampaign]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.InAppMessagesResponse = {
    import InAppMessagesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.InAppMessagesResponse
      .builder()
      .optionallyWith(
        inAppMessageCampaigns.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.inAppMessageCampaigns)
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.InAppMessagesResponse.ReadOnly =
    zio.aws.pinpoint.model.InAppMessagesResponse.wrap(buildAwsValue())
}
object InAppMessagesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.InAppMessagesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.InAppMessagesResponse =
      zio.aws.pinpoint.model.InAppMessagesResponse(
        inAppMessageCampaigns.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def inAppMessageCampaigns
        : Optional[List[zio.aws.pinpoint.model.InAppMessageCampaign.ReadOnly]]
    def getInAppMessageCampaigns: ZIO[Any, AwsError, List[
      zio.aws.pinpoint.model.InAppMessageCampaign.ReadOnly
    ]] =
      AwsError.unwrapOptionField("inAppMessageCampaigns", inAppMessageCampaigns)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.InAppMessagesResponse
  ) extends zio.aws.pinpoint.model.InAppMessagesResponse.ReadOnly {
    override val inAppMessageCampaigns
        : Optional[List[zio.aws.pinpoint.model.InAppMessageCampaign.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.inAppMessageCampaigns())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.pinpoint.model.InAppMessageCampaign.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.InAppMessagesResponse
  ): zio.aws.pinpoint.model.InAppMessagesResponse.ReadOnly = new Wrapper(impl)
}
