package zio.aws.pinpoint.model
import scala.jdk.CollectionConverters.*
sealed trait Include {
  def unwrap: software.amazon.awssdk.services.pinpoint.model.Include
}
object Include {
  def wrap(
      value: software.amazon.awssdk.services.pinpoint.model.Include
  ): zio.aws.pinpoint.model.Include = value match {
    case software.amazon.awssdk.services.pinpoint.model.Include.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.pinpoint.model.Include.ALL =>
      val r = ALL
      r
    case software.amazon.awssdk.services.pinpoint.model.Include.ANY =>
      val r = ANY
      r
    case software.amazon.awssdk.services.pinpoint.model.Include.NONE =>
      val r = NONE
      r
  }
  case object unknownToSdkVersion extends zio.aws.pinpoint.model.Include {
    override def unwrap
        : software.amazon.awssdk.services.pinpoint.model.Include =
      software.amazon.awssdk.services.pinpoint.model.Include.UNKNOWN_TO_SDK_VERSION
  }
  case object ALL extends zio.aws.pinpoint.model.Include {
    override def unwrap
        : software.amazon.awssdk.services.pinpoint.model.Include =
      software.amazon.awssdk.services.pinpoint.model.Include.ALL
  }
  case object ANY extends zio.aws.pinpoint.model.Include {
    override def unwrap
        : software.amazon.awssdk.services.pinpoint.model.Include =
      software.amazon.awssdk.services.pinpoint.model.Include.ANY
  }
  case object NONE extends zio.aws.pinpoint.model.Include {
    override def unwrap
        : software.amazon.awssdk.services.pinpoint.model.Include =
      software.amazon.awssdk.services.pinpoint.model.Include.NONE
  }
}
