package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpoint.model.primitives.__string
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class JourneyChannelSettings(
    connectCampaignArn: Optional[__string] = Optional.Absent,
    connectCampaignExecutionRoleArn: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.JourneyChannelSettings = {
    import JourneyChannelSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.JourneyChannelSettings
      .builder()
      .optionallyWith(connectCampaignArn.map(value => value: java.lang.String))(
        _.connectCampaignArn
      )
      .optionallyWith(
        connectCampaignExecutionRoleArn.map(value => value: java.lang.String)
      )(_.connectCampaignExecutionRoleArn)
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.JourneyChannelSettings.ReadOnly =
    zio.aws.pinpoint.model.JourneyChannelSettings.wrap(buildAwsValue())
}
object JourneyChannelSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.JourneyChannelSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.JourneyChannelSettings =
      zio.aws.pinpoint.model.JourneyChannelSettings(
        connectCampaignArn.map(value => value),
        connectCampaignExecutionRoleArn.map(value => value)
      )
    def connectCampaignArn: Optional[__string]
    def connectCampaignExecutionRoleArn: Optional[__string]
    def getConnectCampaignArn: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("connectCampaignArn", connectCampaignArn)
    def getConnectCampaignExecutionRoleArn: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField(
        "connectCampaignExecutionRoleArn",
        connectCampaignExecutionRoleArn
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.JourneyChannelSettings
  ) extends zio.aws.pinpoint.model.JourneyChannelSettings.ReadOnly {
    override val connectCampaignArn: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.connectCampaignArn())
      .map(value => value: __string)
    override val connectCampaignExecutionRoleArn: Optional[__string] =
      zio.aws.core.internal
        .optionalFromNullable(impl.connectCampaignExecutionRoleArn())
        .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.JourneyChannelSettings
  ): zio.aws.pinpoint.model.JourneyChannelSettings.ReadOnly = new Wrapper(impl)
}
