package zio.aws.pinpoint.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.pinpoint.model.primitives.{__timestampIso8601, __string}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class JourneyDateRangeKpiResponse(
    applicationId: __string,
    endTime: __timestampIso8601,
    journeyId: __string,
    kpiName: __string,
    kpiResult: zio.aws.pinpoint.model.BaseKpiResult,
    nextToken: Optional[__string] = Optional.Absent,
    startTime: __timestampIso8601
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.JourneyDateRangeKpiResponse = {
    import JourneyDateRangeKpiResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.JourneyDateRangeKpiResponse
      .builder()
      .applicationId(applicationId: java.lang.String)
      .endTime(endTime: Instant)
      .journeyId(journeyId: java.lang.String)
      .kpiName(kpiName: java.lang.String)
      .kpiResult(kpiResult.buildAwsValue())
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .startTime(startTime: Instant)
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.JourneyDateRangeKpiResponse.ReadOnly =
    zio.aws.pinpoint.model.JourneyDateRangeKpiResponse.wrap(buildAwsValue())
}
object JourneyDateRangeKpiResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.JourneyDateRangeKpiResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.JourneyDateRangeKpiResponse =
      zio.aws.pinpoint.model.JourneyDateRangeKpiResponse(
        applicationId,
        endTime,
        journeyId,
        kpiName,
        kpiResult.asEditable,
        nextToken.map(value => value),
        startTime
      )
    def applicationId: __string
    def endTime: __timestampIso8601
    def journeyId: __string
    def kpiName: __string
    def kpiResult: zio.aws.pinpoint.model.BaseKpiResult.ReadOnly
    def nextToken: Optional[__string]
    def startTime: __timestampIso8601
    def getApplicationId: ZIO[Any, Nothing, __string] =
      ZIO.succeed(applicationId)
    def getEndTime: ZIO[Any, Nothing, __timestampIso8601] = ZIO.succeed(endTime)
    def getJourneyId: ZIO[Any, Nothing, __string] = ZIO.succeed(journeyId)
    def getKpiName: ZIO[Any, Nothing, __string] = ZIO.succeed(kpiName)
    def getKpiResult
        : ZIO[Any, Nothing, zio.aws.pinpoint.model.BaseKpiResult.ReadOnly] =
      ZIO.succeed(kpiResult)
    def getNextToken: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getStartTime: ZIO[Any, Nothing, __timestampIso8601] =
      ZIO.succeed(startTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.JourneyDateRangeKpiResponse
  ) extends zio.aws.pinpoint.model.JourneyDateRangeKpiResponse.ReadOnly {
    override val applicationId: __string = impl.applicationId(): __string
    override val endTime: __timestampIso8601 =
      impl.endTime(): __timestampIso8601
    override val journeyId: __string = impl.journeyId(): __string
    override val kpiName: __string = impl.kpiName(): __string
    override val kpiResult: zio.aws.pinpoint.model.BaseKpiResult.ReadOnly =
      zio.aws.pinpoint.model.BaseKpiResult.wrap(impl.kpiResult())
    override val nextToken: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: __string)
    override val startTime: __timestampIso8601 =
      impl.startTime(): __timestampIso8601
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.JourneyDateRangeKpiResponse
  ): zio.aws.pinpoint.model.JourneyDateRangeKpiResponse.ReadOnly = new Wrapper(
    impl
  )
}
