package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpoint.model.primitives.__string
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class JourneyEmailMessage(
    fromAddress: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.JourneyEmailMessage = {
    import JourneyEmailMessage.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.JourneyEmailMessage
      .builder()
      .optionallyWith(fromAddress.map(value => value: java.lang.String))(
        _.fromAddress
      )
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.JourneyEmailMessage.ReadOnly =
    zio.aws.pinpoint.model.JourneyEmailMessage.wrap(buildAwsValue())
}
object JourneyEmailMessage {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.JourneyEmailMessage
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.JourneyEmailMessage =
      zio.aws.pinpoint.model
        .JourneyEmailMessage(fromAddress.map(value => value))
    def fromAddress: Optional[__string]
    def getFromAddress: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("fromAddress", fromAddress)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.JourneyEmailMessage
  ) extends zio.aws.pinpoint.model.JourneyEmailMessage.ReadOnly {
    override val fromAddress: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.fromAddress())
      .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.JourneyEmailMessage
  ): zio.aws.pinpoint.model.JourneyEmailMessage.ReadOnly = new Wrapper(impl)
}
