package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpoint.model.primitives.__string
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class JourneyPushMessage(
    timeToLive: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.JourneyPushMessage = {
    import JourneyPushMessage.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.JourneyPushMessage
      .builder()
      .optionallyWith(timeToLive.map(value => value: java.lang.String))(
        _.timeToLive
      )
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.JourneyPushMessage.ReadOnly =
    zio.aws.pinpoint.model.JourneyPushMessage.wrap(buildAwsValue())
}
object JourneyPushMessage {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.JourneyPushMessage
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.JourneyPushMessage =
      zio.aws.pinpoint.model.JourneyPushMessage(timeToLive.map(value => value))
    def timeToLive: Optional[__string]
    def getTimeToLive: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("timeToLive", timeToLive)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.JourneyPushMessage
  ) extends zio.aws.pinpoint.model.JourneyPushMessage.ReadOnly {
    override val timeToLive: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.timeToLive())
      .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.JourneyPushMessage
  ): zio.aws.pinpoint.model.JourneyPushMessage.ReadOnly = new Wrapper(impl)
}
