package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpoint.model.primitives.__string
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class JourneySMSMessage(
    messageType: Optional[zio.aws.pinpoint.model.MessageType] = Optional.Absent,
    originationNumber: Optional[__string] = Optional.Absent,
    senderId: Optional[__string] = Optional.Absent,
    entityId: Optional[__string] = Optional.Absent,
    templateId: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.JourneySMSMessage = {
    import JourneySMSMessage.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.JourneySMSMessage
      .builder()
      .optionallyWith(messageType.map(value => value.unwrap))(_.messageType)
      .optionallyWith(originationNumber.map(value => value: java.lang.String))(
        _.originationNumber
      )
      .optionallyWith(senderId.map(value => value: java.lang.String))(
        _.senderId
      )
      .optionallyWith(entityId.map(value => value: java.lang.String))(
        _.entityId
      )
      .optionallyWith(templateId.map(value => value: java.lang.String))(
        _.templateId
      )
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.JourneySMSMessage.ReadOnly =
    zio.aws.pinpoint.model.JourneySMSMessage.wrap(buildAwsValue())
}
object JourneySMSMessage {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.JourneySMSMessage
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.JourneySMSMessage =
      zio.aws.pinpoint.model.JourneySMSMessage(
        messageType.map(value => value),
        originationNumber.map(value => value),
        senderId.map(value => value),
        entityId.map(value => value),
        templateId.map(value => value)
      )
    def messageType: Optional[zio.aws.pinpoint.model.MessageType]
    def originationNumber: Optional[__string]
    def senderId: Optional[__string]
    def entityId: Optional[__string]
    def templateId: Optional[__string]
    def getMessageType: ZIO[Any, AwsError, zio.aws.pinpoint.model.MessageType] =
      AwsError.unwrapOptionField("messageType", messageType)
    def getOriginationNumber: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("originationNumber", originationNumber)
    def getSenderId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("senderId", senderId)
    def getEntityId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("entityId", entityId)
    def getTemplateId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("templateId", templateId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.JourneySMSMessage
  ) extends zio.aws.pinpoint.model.JourneySMSMessage.ReadOnly {
    override val messageType: Optional[zio.aws.pinpoint.model.MessageType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.messageType())
        .map(value => zio.aws.pinpoint.model.MessageType.wrap(value))
    override val originationNumber: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.originationNumber())
      .map(value => value: __string)
    override val senderId: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.senderId())
      .map(value => value: __string)
    override val entityId: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.entityId())
      .map(value => value: __string)
    override val templateId: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.templateId())
      .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.JourneySMSMessage
  ): zio.aws.pinpoint.model.JourneySMSMessage.ReadOnly = new Wrapper(impl)
}
