package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpoint.model.primitives.__string
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class JourneysResponse(
    item: Iterable[zio.aws.pinpoint.model.JourneyResponse],
    nextToken: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.JourneysResponse = {
    import JourneysResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.JourneysResponse
      .builder()
      .item(item.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.JourneysResponse.ReadOnly =
    zio.aws.pinpoint.model.JourneysResponse.wrap(buildAwsValue())
}
object JourneysResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.JourneysResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.JourneysResponse =
      zio.aws.pinpoint.model.JourneysResponse(
        item.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def item: List[zio.aws.pinpoint.model.JourneyResponse.ReadOnly]
    def nextToken: Optional[__string]
    def getItem: ZIO[Any, Nothing, List[
      zio.aws.pinpoint.model.JourneyResponse.ReadOnly
    ]] = ZIO.succeed(item)
    def getNextToken: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.JourneysResponse
  ) extends zio.aws.pinpoint.model.JourneysResponse.ReadOnly {
    override val item: List[zio.aws.pinpoint.model.JourneyResponse.ReadOnly] =
      impl
        .item()
        .asScala
        .map { item =>
          zio.aws.pinpoint.model.JourneyResponse.wrap(item)
        }
        .toList
    override val nextToken: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.JourneysResponse
  ): zio.aws.pinpoint.model.JourneysResponse.ReadOnly = new Wrapper(impl)
}
