package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class ListTagsForResourceResponse(
    tagsModel: zio.aws.pinpoint.model.TagsModel
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.ListTagsForResourceResponse = {
    import ListTagsForResourceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.ListTagsForResourceResponse
      .builder()
      .tagsModel(tagsModel.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.ListTagsForResourceResponse.ReadOnly =
    zio.aws.pinpoint.model.ListTagsForResourceResponse.wrap(buildAwsValue())
}
object ListTagsForResourceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.ListTagsForResourceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.ListTagsForResourceResponse =
      zio.aws.pinpoint.model.ListTagsForResourceResponse(tagsModel.asEditable)
    def tagsModel: zio.aws.pinpoint.model.TagsModel.ReadOnly
    def getTagsModel
        : ZIO[Any, Nothing, zio.aws.pinpoint.model.TagsModel.ReadOnly] =
      ZIO.succeed(tagsModel)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.ListTagsForResourceResponse
  ) extends zio.aws.pinpoint.model.ListTagsForResourceResponse.ReadOnly {
    override val tagsModel: zio.aws.pinpoint.model.TagsModel.ReadOnly =
      zio.aws.pinpoint.model.TagsModel.wrap(impl.tagsModel())
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.ListTagsForResourceResponse
  ): zio.aws.pinpoint.model.ListTagsForResourceResponse.ReadOnly = new Wrapper(
    impl
  )
}
