package zio.aws.pinpoint.model
import zio.prelude.data.Optional
import zio.aws.pinpoint.model.primitives.{__integer, __boolean, __string}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class Message(
    action: Optional[zio.aws.pinpoint.model.Action] = Optional.Absent,
    body: Optional[__string] = Optional.Absent,
    imageIconUrl: Optional[__string] = Optional.Absent,
    imageSmallIconUrl: Optional[__string] = Optional.Absent,
    imageUrl: Optional[__string] = Optional.Absent,
    jsonBody: Optional[__string] = Optional.Absent,
    mediaUrl: Optional[__string] = Optional.Absent,
    rawContent: Optional[__string] = Optional.Absent,
    silentPush: Optional[__boolean] = Optional.Absent,
    timeToLive: Optional[__integer] = Optional.Absent,
    title: Optional[__string] = Optional.Absent,
    url: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.Message = {
    import Message.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.Message
      .builder()
      .optionallyWith(action.map(value => value.unwrap))(_.action)
      .optionallyWith(body.map(value => value: java.lang.String))(_.body)
      .optionallyWith(imageIconUrl.map(value => value: java.lang.String))(
        _.imageIconUrl
      )
      .optionallyWith(imageSmallIconUrl.map(value => value: java.lang.String))(
        _.imageSmallIconUrl
      )
      .optionallyWith(imageUrl.map(value => value: java.lang.String))(
        _.imageUrl
      )
      .optionallyWith(jsonBody.map(value => value: java.lang.String))(
        _.jsonBody
      )
      .optionallyWith(mediaUrl.map(value => value: java.lang.String))(
        _.mediaUrl
      )
      .optionallyWith(rawContent.map(value => value: java.lang.String))(
        _.rawContent
      )
      .optionallyWith(silentPush.map(value => value: java.lang.Boolean))(
        _.silentPush
      )
      .optionallyWith(timeToLive.map(value => value: Integer))(_.timeToLive)
      .optionallyWith(title.map(value => value: java.lang.String))(_.title)
      .optionallyWith(url.map(value => value: java.lang.String))(_.url)
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.Message.ReadOnly =
    zio.aws.pinpoint.model.Message.wrap(buildAwsValue())
}
object Message {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.pinpoint.model.Message] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.Message =
      zio.aws.pinpoint.model.Message(
        action.map(value => value),
        body.map(value => value),
        imageIconUrl.map(value => value),
        imageSmallIconUrl.map(value => value),
        imageUrl.map(value => value),
        jsonBody.map(value => value),
        mediaUrl.map(value => value),
        rawContent.map(value => value),
        silentPush.map(value => value),
        timeToLive.map(value => value),
        title.map(value => value),
        url.map(value => value)
      )
    def action: Optional[zio.aws.pinpoint.model.Action]
    def body: Optional[__string]
    def imageIconUrl: Optional[__string]
    def imageSmallIconUrl: Optional[__string]
    def imageUrl: Optional[__string]
    def jsonBody: Optional[__string]
    def mediaUrl: Optional[__string]
    def rawContent: Optional[__string]
    def silentPush: Optional[__boolean]
    def timeToLive: Optional[__integer]
    def title: Optional[__string]
    def url: Optional[__string]
    def getAction: ZIO[Any, AwsError, zio.aws.pinpoint.model.Action] =
      AwsError.unwrapOptionField("action", action)
    def getBody: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("body", body)
    def getImageIconUrl: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("imageIconUrl", imageIconUrl)
    def getImageSmallIconUrl: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("imageSmallIconUrl", imageSmallIconUrl)
    def getImageUrl: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("imageUrl", imageUrl)
    def getJsonBody: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("jsonBody", jsonBody)
    def getMediaUrl: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("mediaUrl", mediaUrl)
    def getRawContent: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("rawContent", rawContent)
    def getSilentPush: ZIO[Any, AwsError, __boolean] =
      AwsError.unwrapOptionField("silentPush", silentPush)
    def getTimeToLive: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField("timeToLive", timeToLive)
    def getTitle: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("title", title)
    def getUrl: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("url", url)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.Message
  ) extends zio.aws.pinpoint.model.Message.ReadOnly {
    override val action: Optional[zio.aws.pinpoint.model.Action] =
      zio.aws.core.internal
        .optionalFromNullable(impl.action())
        .map(value => zio.aws.pinpoint.model.Action.wrap(value))
    override val body: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.body())
      .map(value => value: __string)
    override val imageIconUrl: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.imageIconUrl())
      .map(value => value: __string)
    override val imageSmallIconUrl: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.imageSmallIconUrl())
      .map(value => value: __string)
    override val imageUrl: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.imageUrl())
      .map(value => value: __string)
    override val jsonBody: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.jsonBody())
      .map(value => value: __string)
    override val mediaUrl: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.mediaUrl())
      .map(value => value: __string)
    override val rawContent: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.rawContent())
      .map(value => value: __string)
    override val silentPush: Optional[__boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.silentPush())
      .map(value => value: __boolean)
    override val timeToLive: Optional[__integer] = zio.aws.core.internal
      .optionalFromNullable(impl.timeToLive())
      .map(value => value: __integer)
    override val title: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.title())
      .map(value => value: __string)
    override val url: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.url())
      .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.Message
  ): zio.aws.pinpoint.model.Message.ReadOnly = new Wrapper(impl)
}
