package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpoint.model.primitives.__string
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class MessageBody(
    message: Optional[__string] = Optional.Absent,
    requestID: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.MessageBody = {
    import MessageBody.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.MessageBody
      .builder()
      .optionallyWith(message.map(value => value: java.lang.String))(_.message)
      .optionallyWith(requestID.map(value => value: java.lang.String))(
        _.requestID
      )
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.MessageBody.ReadOnly =
    zio.aws.pinpoint.model.MessageBody.wrap(buildAwsValue())
}
object MessageBody {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.MessageBody
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.MessageBody = zio.aws.pinpoint.model
      .MessageBody(message.map(value => value), requestID.map(value => value))
    def message: Optional[__string]
    def requestID: Optional[__string]
    def getMessage: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("message", message)
    def getRequestID: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("requestID", requestID)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.MessageBody
  ) extends zio.aws.pinpoint.model.MessageBody.ReadOnly {
    override val message: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.message())
      .map(value => value: __string)
    override val requestID: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.requestID())
      .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.MessageBody
  ): zio.aws.pinpoint.model.MessageBody.ReadOnly = new Wrapper(impl)
}
