package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class MessageConfiguration(
    admMessage: Optional[zio.aws.pinpoint.model.Message] = Optional.Absent,
    apnsMessage: Optional[zio.aws.pinpoint.model.Message] = Optional.Absent,
    baiduMessage: Optional[zio.aws.pinpoint.model.Message] = Optional.Absent,
    customMessage: Optional[zio.aws.pinpoint.model.CampaignCustomMessage] =
      Optional.Absent,
    defaultMessage: Optional[zio.aws.pinpoint.model.Message] = Optional.Absent,
    emailMessage: Optional[zio.aws.pinpoint.model.CampaignEmailMessage] =
      Optional.Absent,
    gcmMessage: Optional[zio.aws.pinpoint.model.Message] = Optional.Absent,
    smsMessage: Optional[zio.aws.pinpoint.model.CampaignSmsMessage] =
      Optional.Absent,
    inAppMessage: Optional[zio.aws.pinpoint.model.CampaignInAppMessage] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.MessageConfiguration = {
    import MessageConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.MessageConfiguration
      .builder()
      .optionallyWith(admMessage.map(value => value.buildAwsValue()))(
        _.admMessage
      )
      .optionallyWith(apnsMessage.map(value => value.buildAwsValue()))(
        _.apnsMessage
      )
      .optionallyWith(baiduMessage.map(value => value.buildAwsValue()))(
        _.baiduMessage
      )
      .optionallyWith(customMessage.map(value => value.buildAwsValue()))(
        _.customMessage
      )
      .optionallyWith(defaultMessage.map(value => value.buildAwsValue()))(
        _.defaultMessage
      )
      .optionallyWith(emailMessage.map(value => value.buildAwsValue()))(
        _.emailMessage
      )
      .optionallyWith(gcmMessage.map(value => value.buildAwsValue()))(
        _.gcmMessage
      )
      .optionallyWith(smsMessage.map(value => value.buildAwsValue()))(
        _.smsMessage
      )
      .optionallyWith(inAppMessage.map(value => value.buildAwsValue()))(
        _.inAppMessage
      )
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.MessageConfiguration.ReadOnly =
    zio.aws.pinpoint.model.MessageConfiguration.wrap(buildAwsValue())
}
object MessageConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.MessageConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.MessageConfiguration =
      zio.aws.pinpoint.model.MessageConfiguration(
        admMessage.map(value => value.asEditable),
        apnsMessage.map(value => value.asEditable),
        baiduMessage.map(value => value.asEditable),
        customMessage.map(value => value.asEditable),
        defaultMessage.map(value => value.asEditable),
        emailMessage.map(value => value.asEditable),
        gcmMessage.map(value => value.asEditable),
        smsMessage.map(value => value.asEditable),
        inAppMessage.map(value => value.asEditable)
      )
    def admMessage: Optional[zio.aws.pinpoint.model.Message.ReadOnly]
    def apnsMessage: Optional[zio.aws.pinpoint.model.Message.ReadOnly]
    def baiduMessage: Optional[zio.aws.pinpoint.model.Message.ReadOnly]
    def customMessage
        : Optional[zio.aws.pinpoint.model.CampaignCustomMessage.ReadOnly]
    def defaultMessage: Optional[zio.aws.pinpoint.model.Message.ReadOnly]
    def emailMessage
        : Optional[zio.aws.pinpoint.model.CampaignEmailMessage.ReadOnly]
    def gcmMessage: Optional[zio.aws.pinpoint.model.Message.ReadOnly]
    def smsMessage: Optional[zio.aws.pinpoint.model.CampaignSmsMessage.ReadOnly]
    def inAppMessage
        : Optional[zio.aws.pinpoint.model.CampaignInAppMessage.ReadOnly]
    def getAdmMessage
        : ZIO[Any, AwsError, zio.aws.pinpoint.model.Message.ReadOnly] =
      AwsError.unwrapOptionField("admMessage", admMessage)
    def getApnsMessage
        : ZIO[Any, AwsError, zio.aws.pinpoint.model.Message.ReadOnly] =
      AwsError.unwrapOptionField("apnsMessage", apnsMessage)
    def getBaiduMessage
        : ZIO[Any, AwsError, zio.aws.pinpoint.model.Message.ReadOnly] =
      AwsError.unwrapOptionField("baiduMessage", baiduMessage)
    def getCustomMessage: ZIO[
      Any,
      AwsError,
      zio.aws.pinpoint.model.CampaignCustomMessage.ReadOnly
    ] = AwsError.unwrapOptionField("customMessage", customMessage)
    def getDefaultMessage
        : ZIO[Any, AwsError, zio.aws.pinpoint.model.Message.ReadOnly] =
      AwsError.unwrapOptionField("defaultMessage", defaultMessage)
    def getEmailMessage: ZIO[
      Any,
      AwsError,
      zio.aws.pinpoint.model.CampaignEmailMessage.ReadOnly
    ] = AwsError.unwrapOptionField("emailMessage", emailMessage)
    def getGcmMessage
        : ZIO[Any, AwsError, zio.aws.pinpoint.model.Message.ReadOnly] =
      AwsError.unwrapOptionField("gcmMessage", gcmMessage)
    def getSmsMessage: ZIO[
      Any,
      AwsError,
      zio.aws.pinpoint.model.CampaignSmsMessage.ReadOnly
    ] = AwsError.unwrapOptionField("smsMessage", smsMessage)
    def getInAppMessage: ZIO[
      Any,
      AwsError,
      zio.aws.pinpoint.model.CampaignInAppMessage.ReadOnly
    ] = AwsError.unwrapOptionField("inAppMessage", inAppMessage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.MessageConfiguration
  ) extends zio.aws.pinpoint.model.MessageConfiguration.ReadOnly {
    override val admMessage: Optional[zio.aws.pinpoint.model.Message.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.admMessage())
        .map(value => zio.aws.pinpoint.model.Message.wrap(value))
    override val apnsMessage
        : Optional[zio.aws.pinpoint.model.Message.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.apnsMessage())
        .map(value => zio.aws.pinpoint.model.Message.wrap(value))
    override val baiduMessage
        : Optional[zio.aws.pinpoint.model.Message.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.baiduMessage())
        .map(value => zio.aws.pinpoint.model.Message.wrap(value))
    override val customMessage
        : Optional[zio.aws.pinpoint.model.CampaignCustomMessage.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.customMessage())
        .map(value => zio.aws.pinpoint.model.CampaignCustomMessage.wrap(value))
    override val defaultMessage
        : Optional[zio.aws.pinpoint.model.Message.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.defaultMessage())
        .map(value => zio.aws.pinpoint.model.Message.wrap(value))
    override val emailMessage
        : Optional[zio.aws.pinpoint.model.CampaignEmailMessage.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.emailMessage())
        .map(value => zio.aws.pinpoint.model.CampaignEmailMessage.wrap(value))
    override val gcmMessage: Optional[zio.aws.pinpoint.model.Message.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.gcmMessage())
        .map(value => zio.aws.pinpoint.model.Message.wrap(value))
    override val smsMessage
        : Optional[zio.aws.pinpoint.model.CampaignSmsMessage.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.smsMessage())
        .map(value => zio.aws.pinpoint.model.CampaignSmsMessage.wrap(value))
    override val inAppMessage
        : Optional[zio.aws.pinpoint.model.CampaignInAppMessage.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.inAppMessage())
        .map(value => zio.aws.pinpoint.model.CampaignInAppMessage.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.MessageConfiguration
  ): zio.aws.pinpoint.model.MessageConfiguration.ReadOnly = new Wrapper(impl)
}
