package zio.aws.pinpoint.model
import zio.prelude.data.Optional
import zio.aws.pinpoint.model.primitives.{__integer, __string}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class MessageResult(
    deliveryStatus: zio.aws.pinpoint.model.DeliveryStatus,
    messageId: Optional[__string] = Optional.Absent,
    statusCode: __integer,
    statusMessage: Optional[__string] = Optional.Absent,
    updatedToken: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.MessageResult = {
    import MessageResult.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.MessageResult
      .builder()
      .deliveryStatus(deliveryStatus.unwrap)
      .optionallyWith(messageId.map(value => value: java.lang.String))(
        _.messageId
      )
      .statusCode(statusCode: Integer)
      .optionallyWith(statusMessage.map(value => value: java.lang.String))(
        _.statusMessage
      )
      .optionallyWith(updatedToken.map(value => value: java.lang.String))(
        _.updatedToken
      )
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.MessageResult.ReadOnly =
    zio.aws.pinpoint.model.MessageResult.wrap(buildAwsValue())
}
object MessageResult {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.MessageResult
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.MessageResult =
      zio.aws.pinpoint.model.MessageResult(
        deliveryStatus,
        messageId.map(value => value),
        statusCode,
        statusMessage.map(value => value),
        updatedToken.map(value => value)
      )
    def deliveryStatus: zio.aws.pinpoint.model.DeliveryStatus
    def messageId: Optional[__string]
    def statusCode: __integer
    def statusMessage: Optional[__string]
    def updatedToken: Optional[__string]
    def getDeliveryStatus
        : ZIO[Any, Nothing, zio.aws.pinpoint.model.DeliveryStatus] =
      ZIO.succeed(deliveryStatus)
    def getMessageId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("messageId", messageId)
    def getStatusCode: ZIO[Any, Nothing, __integer] = ZIO.succeed(statusCode)
    def getStatusMessage: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("statusMessage", statusMessage)
    def getUpdatedToken: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("updatedToken", updatedToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.MessageResult
  ) extends zio.aws.pinpoint.model.MessageResult.ReadOnly {
    override val deliveryStatus: zio.aws.pinpoint.model.DeliveryStatus =
      zio.aws.pinpoint.model.DeliveryStatus.wrap(impl.deliveryStatus())
    override val messageId: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.messageId())
      .map(value => value: __string)
    override val statusCode: __integer = impl.statusCode(): __integer
    override val statusMessage: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.statusMessage())
      .map(value => value: __string)
    override val updatedToken: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.updatedToken())
      .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.MessageResult
  ): zio.aws.pinpoint.model.MessageResult.ReadOnly = new Wrapper(impl)
}
