package zio.aws.pinpoint.model
import scala.jdk.CollectionConverters.*
sealed trait Mode {
  def unwrap: software.amazon.awssdk.services.pinpoint.model.Mode
}
object Mode {
  def wrap(
      value: software.amazon.awssdk.services.pinpoint.model.Mode
  ): zio.aws.pinpoint.model.Mode = value match {
    case software.amazon.awssdk.services.pinpoint.model.Mode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.pinpoint.model.Mode.DELIVERY =>
      val r = DELIVERY
      r
    case software.amazon.awssdk.services.pinpoint.model.Mode.FILTER =>
      val r = FILTER
      r
  }
  case object unknownToSdkVersion extends zio.aws.pinpoint.model.Mode {
    override def unwrap: software.amazon.awssdk.services.pinpoint.model.Mode =
      software.amazon.awssdk.services.pinpoint.model.Mode.UNKNOWN_TO_SDK_VERSION
  }
  case object DELIVERY extends zio.aws.pinpoint.model.Mode {
    override def unwrap: software.amazon.awssdk.services.pinpoint.model.Mode =
      software.amazon.awssdk.services.pinpoint.model.Mode.DELIVERY
  }
  case object FILTER extends zio.aws.pinpoint.model.Mode {
    override def unwrap: software.amazon.awssdk.services.pinpoint.model.Mode =
      software.amazon.awssdk.services.pinpoint.model.Mode.FILTER
  }
}
