package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpoint.model.primitives.__string
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class NumberValidateRequest(
    isoCountryCode: Optional[__string] = Optional.Absent,
    phoneNumber: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.NumberValidateRequest = {
    import NumberValidateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.NumberValidateRequest
      .builder()
      .optionallyWith(isoCountryCode.map(value => value: java.lang.String))(
        _.isoCountryCode
      )
      .optionallyWith(phoneNumber.map(value => value: java.lang.String))(
        _.phoneNumber
      )
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.NumberValidateRequest.ReadOnly =
    zio.aws.pinpoint.model.NumberValidateRequest.wrap(buildAwsValue())
}
object NumberValidateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.NumberValidateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.NumberValidateRequest =
      zio.aws.pinpoint.model.NumberValidateRequest(
        isoCountryCode.map(value => value),
        phoneNumber.map(value => value)
      )
    def isoCountryCode: Optional[__string]
    def phoneNumber: Optional[__string]
    def getIsoCountryCode: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("isoCountryCode", isoCountryCode)
    def getPhoneNumber: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("phoneNumber", phoneNumber)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.NumberValidateRequest
  ) extends zio.aws.pinpoint.model.NumberValidateRequest.ReadOnly {
    override val isoCountryCode: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.isoCountryCode())
      .map(value => value: __string)
    override val phoneNumber: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.phoneNumber())
      .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.NumberValidateRequest
  ): zio.aws.pinpoint.model.NumberValidateRequest.ReadOnly = new Wrapper(impl)
}
