package zio.aws.pinpoint.model
import zio.prelude.data.Optional
import zio.aws.pinpoint.model.primitives.{__integer, __string}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class NumberValidateResponse(
    carrier: Optional[__string] = Optional.Absent,
    city: Optional[__string] = Optional.Absent,
    cleansedPhoneNumberE164: Optional[__string] = Optional.Absent,
    cleansedPhoneNumberNational: Optional[__string] = Optional.Absent,
    country: Optional[__string] = Optional.Absent,
    countryCodeIso2: Optional[__string] = Optional.Absent,
    countryCodeNumeric: Optional[__string] = Optional.Absent,
    county: Optional[__string] = Optional.Absent,
    originalCountryCodeIso2: Optional[__string] = Optional.Absent,
    originalPhoneNumber: Optional[__string] = Optional.Absent,
    phoneType: Optional[__string] = Optional.Absent,
    phoneTypeCode: Optional[__integer] = Optional.Absent,
    timezone: Optional[__string] = Optional.Absent,
    zipCode: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.NumberValidateResponse = {
    import NumberValidateResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.NumberValidateResponse
      .builder()
      .optionallyWith(carrier.map(value => value: java.lang.String))(_.carrier)
      .optionallyWith(city.map(value => value: java.lang.String))(_.city)
      .optionallyWith(
        cleansedPhoneNumberE164.map(value => value: java.lang.String)
      )(_.cleansedPhoneNumberE164)
      .optionallyWith(
        cleansedPhoneNumberNational.map(value => value: java.lang.String)
      )(_.cleansedPhoneNumberNational)
      .optionallyWith(country.map(value => value: java.lang.String))(_.country)
      .optionallyWith(countryCodeIso2.map(value => value: java.lang.String))(
        _.countryCodeIso2
      )
      .optionallyWith(countryCodeNumeric.map(value => value: java.lang.String))(
        _.countryCodeNumeric
      )
      .optionallyWith(county.map(value => value: java.lang.String))(_.county)
      .optionallyWith(
        originalCountryCodeIso2.map(value => value: java.lang.String)
      )(_.originalCountryCodeIso2)
      .optionallyWith(
        originalPhoneNumber.map(value => value: java.lang.String)
      )(_.originalPhoneNumber)
      .optionallyWith(phoneType.map(value => value: java.lang.String))(
        _.phoneType
      )
      .optionallyWith(phoneTypeCode.map(value => value: Integer))(
        _.phoneTypeCode
      )
      .optionallyWith(timezone.map(value => value: java.lang.String))(
        _.timezone
      )
      .optionallyWith(zipCode.map(value => value: java.lang.String))(_.zipCode)
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.NumberValidateResponse.ReadOnly =
    zio.aws.pinpoint.model.NumberValidateResponse.wrap(buildAwsValue())
}
object NumberValidateResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.NumberValidateResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.NumberValidateResponse =
      zio.aws.pinpoint.model.NumberValidateResponse(
        carrier.map(value => value),
        city.map(value => value),
        cleansedPhoneNumberE164.map(value => value),
        cleansedPhoneNumberNational.map(value => value),
        country.map(value => value),
        countryCodeIso2.map(value => value),
        countryCodeNumeric.map(value => value),
        county.map(value => value),
        originalCountryCodeIso2.map(value => value),
        originalPhoneNumber.map(value => value),
        phoneType.map(value => value),
        phoneTypeCode.map(value => value),
        timezone.map(value => value),
        zipCode.map(value => value)
      )
    def carrier: Optional[__string]
    def city: Optional[__string]
    def cleansedPhoneNumberE164: Optional[__string]
    def cleansedPhoneNumberNational: Optional[__string]
    def country: Optional[__string]
    def countryCodeIso2: Optional[__string]
    def countryCodeNumeric: Optional[__string]
    def county: Optional[__string]
    def originalCountryCodeIso2: Optional[__string]
    def originalPhoneNumber: Optional[__string]
    def phoneType: Optional[__string]
    def phoneTypeCode: Optional[__integer]
    def timezone: Optional[__string]
    def zipCode: Optional[__string]
    def getCarrier: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("carrier", carrier)
    def getCity: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("city", city)
    def getCleansedPhoneNumberE164: ZIO[Any, AwsError, __string] = AwsError
      .unwrapOptionField("cleansedPhoneNumberE164", cleansedPhoneNumberE164)
    def getCleansedPhoneNumberNational: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField(
        "cleansedPhoneNumberNational",
        cleansedPhoneNumberNational
      )
    def getCountry: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("country", country)
    def getCountryCodeIso2: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("countryCodeIso2", countryCodeIso2)
    def getCountryCodeNumeric: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("countryCodeNumeric", countryCodeNumeric)
    def getCounty: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("county", county)
    def getOriginalCountryCodeIso2: ZIO[Any, AwsError, __string] = AwsError
      .unwrapOptionField("originalCountryCodeIso2", originalCountryCodeIso2)
    def getOriginalPhoneNumber: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("originalPhoneNumber", originalPhoneNumber)
    def getPhoneType: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("phoneType", phoneType)
    def getPhoneTypeCode: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField("phoneTypeCode", phoneTypeCode)
    def getTimezone: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("timezone", timezone)
    def getZipCode: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("zipCode", zipCode)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.NumberValidateResponse
  ) extends zio.aws.pinpoint.model.NumberValidateResponse.ReadOnly {
    override val carrier: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.carrier())
      .map(value => value: __string)
    override val city: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.city())
      .map(value => value: __string)
    override val cleansedPhoneNumberE164: Optional[__string] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cleansedPhoneNumberE164())
        .map(value => value: __string)
    override val cleansedPhoneNumberNational: Optional[__string] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cleansedPhoneNumberNational())
        .map(value => value: __string)
    override val country: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.country())
      .map(value => value: __string)
    override val countryCodeIso2: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.countryCodeIso2())
      .map(value => value: __string)
    override val countryCodeNumeric: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.countryCodeNumeric())
      .map(value => value: __string)
    override val county: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.county())
      .map(value => value: __string)
    override val originalCountryCodeIso2: Optional[__string] =
      zio.aws.core.internal
        .optionalFromNullable(impl.originalCountryCodeIso2())
        .map(value => value: __string)
    override val originalPhoneNumber: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.originalPhoneNumber())
      .map(value => value: __string)
    override val phoneType: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.phoneType())
      .map(value => value: __string)
    override val phoneTypeCode: Optional[__integer] = zio.aws.core.internal
      .optionalFromNullable(impl.phoneTypeCode())
      .map(value => value: __integer)
    override val timezone: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.timezone())
      .map(value => value: __string)
    override val zipCode: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.zipCode())
      .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.NumberValidateResponse
  ): zio.aws.pinpoint.model.NumberValidateResponse.ReadOnly = new Wrapper(impl)
}
