package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpoint.model.primitives.__string
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class OpenHoursRule(
    startTime: Optional[__string] = Optional.Absent,
    endTime: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.OpenHoursRule = {
    import OpenHoursRule.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.OpenHoursRule
      .builder()
      .optionallyWith(startTime.map(value => value: java.lang.String))(
        _.startTime
      )
      .optionallyWith(endTime.map(value => value: java.lang.String))(_.endTime)
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.OpenHoursRule.ReadOnly =
    zio.aws.pinpoint.model.OpenHoursRule.wrap(buildAwsValue())
}
object OpenHoursRule {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.OpenHoursRule
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.OpenHoursRule =
      zio.aws.pinpoint.model.OpenHoursRule(
        startTime.map(value => value),
        endTime.map(value => value)
      )
    def startTime: Optional[__string]
    def endTime: Optional[__string]
    def getStartTime: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("startTime", startTime)
    def getEndTime: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("endTime", endTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.OpenHoursRule
  ) extends zio.aws.pinpoint.model.OpenHoursRule.ReadOnly {
    override val startTime: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.startTime())
      .map(value => value: __string)
    override val endTime: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.endTime())
      .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.OpenHoursRule
  ): zio.aws.pinpoint.model.OpenHoursRule.ReadOnly = new Wrapper(impl)
}
