package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpoint.model.primitives.__string
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class OverrideButtonConfiguration(
    buttonAction: zio.aws.pinpoint.model.ButtonAction,
    link: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.OverrideButtonConfiguration = {
    import OverrideButtonConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.OverrideButtonConfiguration
      .builder()
      .buttonAction(buttonAction.unwrap)
      .optionallyWith(link.map(value => value: java.lang.String))(_.link)
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.OverrideButtonConfiguration.ReadOnly =
    zio.aws.pinpoint.model.OverrideButtonConfiguration.wrap(buildAwsValue())
}
object OverrideButtonConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.OverrideButtonConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.OverrideButtonConfiguration =
      zio.aws.pinpoint.model
        .OverrideButtonConfiguration(buttonAction, link.map(value => value))
    def buttonAction: zio.aws.pinpoint.model.ButtonAction
    def link: Optional[__string]
    def getButtonAction
        : ZIO[Any, Nothing, zio.aws.pinpoint.model.ButtonAction] =
      ZIO.succeed(buttonAction)
    def getLink: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("link", link)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.OverrideButtonConfiguration
  ) extends zio.aws.pinpoint.model.OverrideButtonConfiguration.ReadOnly {
    override val buttonAction: zio.aws.pinpoint.model.ButtonAction =
      zio.aws.pinpoint.model.ButtonAction.wrap(impl.buttonAction())
    override val link: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.link())
      .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.OverrideButtonConfiguration
  ): zio.aws.pinpoint.model.OverrideButtonConfiguration.ReadOnly = new Wrapper(
    impl
  )
}
