package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpoint.model.primitives.__string
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class PushNotificationTemplateResponse(
    adm: Optional[zio.aws.pinpoint.model.AndroidPushNotificationTemplate] =
      Optional.Absent,
    apns: Optional[zio.aws.pinpoint.model.APNSPushNotificationTemplate] =
      Optional.Absent,
    arn: Optional[__string] = Optional.Absent,
    baidu: Optional[zio.aws.pinpoint.model.AndroidPushNotificationTemplate] =
      Optional.Absent,
    creationDate: __string,
    defaultValue: Optional[
      zio.aws.pinpoint.model.DefaultPushNotificationTemplate
    ] = Optional.Absent,
    defaultSubstitutions: Optional[__string] = Optional.Absent,
    gcm: Optional[zio.aws.pinpoint.model.AndroidPushNotificationTemplate] =
      Optional.Absent,
    lastModifiedDate: __string,
    recommenderId: Optional[__string] = Optional.Absent,
    tags: Optional[Map[__string, __string]] = Optional.Absent,
    templateDescription: Optional[__string] = Optional.Absent,
    templateName: __string,
    templateType: zio.aws.pinpoint.model.TemplateType,
    version: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.PushNotificationTemplateResponse = {
    import PushNotificationTemplateResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.PushNotificationTemplateResponse
      .builder()
      .optionallyWith(adm.map(value => value.buildAwsValue()))(_.adm)
      .optionallyWith(apns.map(value => value.buildAwsValue()))(_.apns)
      .optionallyWith(arn.map(value => value: java.lang.String))(_.arn)
      .optionallyWith(baidu.map(value => value.buildAwsValue()))(_.baidu)
      .creationDate(creationDate: java.lang.String)
      .optionallyWith(defaultValue.map(value => value.buildAwsValue()))(
        _.defaultValue
      )
      .optionallyWith(
        defaultSubstitutions.map(value => value: java.lang.String)
      )(_.defaultSubstitutions)
      .optionallyWith(gcm.map(value => value.buildAwsValue()))(_.gcm)
      .lastModifiedDate(lastModifiedDate: java.lang.String)
      .optionallyWith(recommenderId.map(value => value: java.lang.String))(
        _.recommenderId
      )
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(
        templateDescription.map(value => value: java.lang.String)
      )(_.templateDescription)
      .templateName(templateName: java.lang.String)
      .templateType(templateType.unwrap)
      .optionallyWith(version.map(value => value: java.lang.String))(_.version)
      .build()
  }
  def asReadOnly
      : zio.aws.pinpoint.model.PushNotificationTemplateResponse.ReadOnly =
    zio.aws.pinpoint.model.PushNotificationTemplateResponse
      .wrap(buildAwsValue())
}
object PushNotificationTemplateResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.PushNotificationTemplateResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.PushNotificationTemplateResponse =
      zio.aws.pinpoint.model.PushNotificationTemplateResponse(
        adm.map(value => value.asEditable),
        apns.map(value => value.asEditable),
        arn.map(value => value),
        baidu.map(value => value.asEditable),
        creationDate,
        defaultValue.map(value => value.asEditable),
        defaultSubstitutions.map(value => value),
        gcm.map(value => value.asEditable),
        lastModifiedDate,
        recommenderId.map(value => value),
        tags.map(value => value),
        templateDescription.map(value => value),
        templateName,
        templateType,
        version.map(value => value)
      )
    def adm: Optional[
      zio.aws.pinpoint.model.AndroidPushNotificationTemplate.ReadOnly
    ]
    def apns
        : Optional[zio.aws.pinpoint.model.APNSPushNotificationTemplate.ReadOnly]
    def arn: Optional[__string]
    def baidu: Optional[
      zio.aws.pinpoint.model.AndroidPushNotificationTemplate.ReadOnly
    ]
    def creationDate: __string
    def defaultValue: Optional[
      zio.aws.pinpoint.model.DefaultPushNotificationTemplate.ReadOnly
    ]
    def defaultSubstitutions: Optional[__string]
    def gcm: Optional[
      zio.aws.pinpoint.model.AndroidPushNotificationTemplate.ReadOnly
    ]
    def lastModifiedDate: __string
    def recommenderId: Optional[__string]
    def tags: Optional[Map[__string, __string]]
    def templateDescription: Optional[__string]
    def templateName: __string
    def templateType: zio.aws.pinpoint.model.TemplateType
    def version: Optional[__string]
    def getAdm: ZIO[
      Any,
      AwsError,
      zio.aws.pinpoint.model.AndroidPushNotificationTemplate.ReadOnly
    ] = AwsError.unwrapOptionField("adm", adm)
    def getApns: ZIO[
      Any,
      AwsError,
      zio.aws.pinpoint.model.APNSPushNotificationTemplate.ReadOnly
    ] = AwsError.unwrapOptionField("apns", apns)
    def getArn: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("arn", arn)
    def getBaidu: ZIO[
      Any,
      AwsError,
      zio.aws.pinpoint.model.AndroidPushNotificationTemplate.ReadOnly
    ] = AwsError.unwrapOptionField("baidu", baidu)
    def getCreationDate: ZIO[Any, Nothing, __string] = ZIO.succeed(creationDate)
    def getDefaultValue: ZIO[
      Any,
      AwsError,
      zio.aws.pinpoint.model.DefaultPushNotificationTemplate.ReadOnly
    ] = AwsError.unwrapOptionField("defaultValue", defaultValue)
    def getDefaultSubstitutions: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("defaultSubstitutions", defaultSubstitutions)
    def getGcm: ZIO[
      Any,
      AwsError,
      zio.aws.pinpoint.model.AndroidPushNotificationTemplate.ReadOnly
    ] = AwsError.unwrapOptionField("gcm", gcm)
    def getLastModifiedDate: ZIO[Any, Nothing, __string] =
      ZIO.succeed(lastModifiedDate)
    def getRecommenderId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("recommenderId", recommenderId)
    def getTags: ZIO[Any, AwsError, Map[__string, __string]] =
      AwsError.unwrapOptionField("tags", tags)
    def getTemplateDescription: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("templateDescription", templateDescription)
    def getTemplateName: ZIO[Any, Nothing, __string] = ZIO.succeed(templateName)
    def getTemplateType
        : ZIO[Any, Nothing, zio.aws.pinpoint.model.TemplateType] =
      ZIO.succeed(templateType)
    def getVersion: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("version", version)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.PushNotificationTemplateResponse
  ) extends zio.aws.pinpoint.model.PushNotificationTemplateResponse.ReadOnly {
    override val adm: Optional[
      zio.aws.pinpoint.model.AndroidPushNotificationTemplate.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.adm())
      .map(value =>
        zio.aws.pinpoint.model.AndroidPushNotificationTemplate.wrap(value)
      )
    override val apns: Optional[
      zio.aws.pinpoint.model.APNSPushNotificationTemplate.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.apns())
      .map(value =>
        zio.aws.pinpoint.model.APNSPushNotificationTemplate.wrap(value)
      )
    override val arn: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => value: __string)
    override val baidu: Optional[
      zio.aws.pinpoint.model.AndroidPushNotificationTemplate.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.baidu())
      .map(value =>
        zio.aws.pinpoint.model.AndroidPushNotificationTemplate.wrap(value)
      )
    override val creationDate: __string = impl.creationDate(): __string
    override val defaultValue: Optional[
      zio.aws.pinpoint.model.DefaultPushNotificationTemplate.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.defaultValue())
      .map(value =>
        zio.aws.pinpoint.model.DefaultPushNotificationTemplate.wrap(value)
      )
    override val defaultSubstitutions: Optional[__string] =
      zio.aws.core.internal
        .optionalFromNullable(impl.defaultSubstitutions())
        .map(value => value: __string)
    override val gcm: Optional[
      zio.aws.pinpoint.model.AndroidPushNotificationTemplate.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.gcm())
      .map(value =>
        zio.aws.pinpoint.model.AndroidPushNotificationTemplate.wrap(value)
      )
    override val lastModifiedDate: __string = impl.lastModifiedDate(): __string
    override val recommenderId: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.recommenderId())
      .map(value => value: __string)
    override val tags: Optional[Map[__string, __string]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: __string) -> (value: __string)
          })
          .toMap
      )
    override val templateDescription: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.templateDescription())
      .map(value => value: __string)
    override val templateName: __string = impl.templateName(): __string
    override val templateType: zio.aws.pinpoint.model.TemplateType =
      zio.aws.pinpoint.model.TemplateType.wrap(impl.templateType())
    override val version: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.version())
      .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.PushNotificationTemplateResponse
  ): zio.aws.pinpoint.model.PushNotificationTemplateResponse.ReadOnly =
    new Wrapper(impl)
}
