package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class PutEventStreamResponse(
    eventStream: zio.aws.pinpoint.model.EventStream
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.PutEventStreamResponse = {
    import PutEventStreamResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.PutEventStreamResponse
      .builder()
      .eventStream(eventStream.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.PutEventStreamResponse.ReadOnly =
    zio.aws.pinpoint.model.PutEventStreamResponse.wrap(buildAwsValue())
}
object PutEventStreamResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.PutEventStreamResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.PutEventStreamResponse =
      zio.aws.pinpoint.model.PutEventStreamResponse(eventStream.asEditable)
    def eventStream: zio.aws.pinpoint.model.EventStream.ReadOnly
    def getEventStream
        : ZIO[Any, Nothing, zio.aws.pinpoint.model.EventStream.ReadOnly] =
      ZIO.succeed(eventStream)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.PutEventStreamResponse
  ) extends zio.aws.pinpoint.model.PutEventStreamResponse.ReadOnly {
    override val eventStream: zio.aws.pinpoint.model.EventStream.ReadOnly =
      zio.aws.pinpoint.model.EventStream.wrap(impl.eventStream())
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.PutEventStreamResponse
  ): zio.aws.pinpoint.model.PutEventStreamResponse.ReadOnly = new Wrapper(impl)
}
