package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class RandomSplitActivity(
    branches: Optional[Iterable[zio.aws.pinpoint.model.RandomSplitEntry]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.RandomSplitActivity = {
    import RandomSplitActivity.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.RandomSplitActivity
      .builder()
      .optionallyWith(
        branches.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.branches)
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.RandomSplitActivity.ReadOnly =
    zio.aws.pinpoint.model.RandomSplitActivity.wrap(buildAwsValue())
}
object RandomSplitActivity {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.RandomSplitActivity
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.RandomSplitActivity =
      zio.aws.pinpoint.model.RandomSplitActivity(
        branches.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def branches
        : Optional[List[zio.aws.pinpoint.model.RandomSplitEntry.ReadOnly]]
    def getBranches: ZIO[Any, AwsError, List[
      zio.aws.pinpoint.model.RandomSplitEntry.ReadOnly
    ]] = AwsError.unwrapOptionField("branches", branches)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.RandomSplitActivity
  ) extends zio.aws.pinpoint.model.RandomSplitActivity.ReadOnly {
    override val branches
        : Optional[List[zio.aws.pinpoint.model.RandomSplitEntry.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.branches())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.pinpoint.model.RandomSplitEntry.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.RandomSplitActivity
  ): zio.aws.pinpoint.model.RandomSplitActivity.ReadOnly = new Wrapper(impl)
}
