package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpoint.model.primitives.__blob
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class RawEmail(data: Optional[__blob] = Optional.Absent) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.RawEmail = {
    import RawEmail.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.RawEmail
      .builder()
      .optionallyWith(
        data.map(value =>
          software.amazon.awssdk.core.SdkBytes
            .fromByteArrayUnsafe(value.toArray[Byte])
        )
      )(_.data)
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.RawEmail.ReadOnly =
    zio.aws.pinpoint.model.RawEmail.wrap(buildAwsValue())
}
object RawEmail {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.pinpoint.model.RawEmail] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.RawEmail =
      zio.aws.pinpoint.model.RawEmail(data.map(value => value))
    def data: Optional[__blob]
    def getData: ZIO[Any, AwsError, __blob] =
      AwsError.unwrapOptionField("data", data)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.RawEmail
  ) extends zio.aws.pinpoint.model.RawEmail.ReadOnly {
    override val data: Optional[__blob] = zio.aws.core.internal
      .optionalFromNullable(impl.data())
      .map(value => zio.Chunk.fromArray(value.asByteArrayUnsafe()): __blob)
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.RawEmail
  ): zio.aws.pinpoint.model.RawEmail.ReadOnly = new Wrapper(impl)
}
