package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpoint.model.primitives.{__string, __boolean}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class SMSChannelRequest(
    enabled: Optional[__boolean] = Optional.Absent,
    senderId: Optional[__string] = Optional.Absent,
    shortCode: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.SMSChannelRequest = {
    import SMSChannelRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.SMSChannelRequest
      .builder()
      .optionallyWith(enabled.map(value => value: java.lang.Boolean))(_.enabled)
      .optionallyWith(senderId.map(value => value: java.lang.String))(
        _.senderId
      )
      .optionallyWith(shortCode.map(value => value: java.lang.String))(
        _.shortCode
      )
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.SMSChannelRequest.ReadOnly =
    zio.aws.pinpoint.model.SMSChannelRequest.wrap(buildAwsValue())
}
object SMSChannelRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.SMSChannelRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.SMSChannelRequest =
      zio.aws.pinpoint.model.SMSChannelRequest(
        enabled.map(value => value),
        senderId.map(value => value),
        shortCode.map(value => value)
      )
    def enabled: Optional[__boolean]
    def senderId: Optional[__string]
    def shortCode: Optional[__string]
    def getEnabled: ZIO[Any, AwsError, __boolean] =
      AwsError.unwrapOptionField("enabled", enabled)
    def getSenderId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("senderId", senderId)
    def getShortCode: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("shortCode", shortCode)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.SMSChannelRequest
  ) extends zio.aws.pinpoint.model.SMSChannelRequest.ReadOnly {
    override val enabled: Optional[__boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.enabled())
      .map(value => value: __boolean)
    override val senderId: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.senderId())
      .map(value => value: __string)
    override val shortCode: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.shortCode())
      .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.SMSChannelRequest
  ): zio.aws.pinpoint.model.SMSChannelRequest.ReadOnly = new Wrapper(impl)
}
