package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpoint.model.primitives.__string
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class SMSMessage(
    body: Optional[__string] = Optional.Absent,
    keyword: Optional[__string] = Optional.Absent,
    mediaUrl: Optional[__string] = Optional.Absent,
    messageType: Optional[zio.aws.pinpoint.model.MessageType] = Optional.Absent,
    originationNumber: Optional[__string] = Optional.Absent,
    senderId: Optional[__string] = Optional.Absent,
    substitutions: Optional[Map[__string, Iterable[__string]]] =
      Optional.Absent,
    entityId: Optional[__string] = Optional.Absent,
    templateId: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.SMSMessage = {
    import SMSMessage.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.SMSMessage
      .builder()
      .optionallyWith(body.map(value => value: java.lang.String))(_.body)
      .optionallyWith(keyword.map(value => value: java.lang.String))(_.keyword)
      .optionallyWith(mediaUrl.map(value => value: java.lang.String))(
        _.mediaUrl
      )
      .optionallyWith(messageType.map(value => value.unwrap))(_.messageType)
      .optionallyWith(originationNumber.map(value => value: java.lang.String))(
        _.originationNumber
      )
      .optionallyWith(senderId.map(value => value: java.lang.String))(
        _.senderId
      )
      .optionallyWith(
        substitutions.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> value.map { item =>
                item: java.lang.String
              }.asJavaCollection
            })
            .asJava
        )
      )(_.substitutions)
      .optionallyWith(entityId.map(value => value: java.lang.String))(
        _.entityId
      )
      .optionallyWith(templateId.map(value => value: java.lang.String))(
        _.templateId
      )
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.SMSMessage.ReadOnly =
    zio.aws.pinpoint.model.SMSMessage.wrap(buildAwsValue())
}
object SMSMessage {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.SMSMessage
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.SMSMessage =
      zio.aws.pinpoint.model.SMSMessage(
        body.map(value => value),
        keyword.map(value => value),
        mediaUrl.map(value => value),
        messageType.map(value => value),
        originationNumber.map(value => value),
        senderId.map(value => value),
        substitutions.map(value => value),
        entityId.map(value => value),
        templateId.map(value => value)
      )
    def body: Optional[__string]
    def keyword: Optional[__string]
    def mediaUrl: Optional[__string]
    def messageType: Optional[zio.aws.pinpoint.model.MessageType]
    def originationNumber: Optional[__string]
    def senderId: Optional[__string]
    def substitutions: Optional[Map[__string, List[__string]]]
    def entityId: Optional[__string]
    def templateId: Optional[__string]
    def getBody: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("body", body)
    def getKeyword: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("keyword", keyword)
    def getMediaUrl: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("mediaUrl", mediaUrl)
    def getMessageType: ZIO[Any, AwsError, zio.aws.pinpoint.model.MessageType] =
      AwsError.unwrapOptionField("messageType", messageType)
    def getOriginationNumber: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("originationNumber", originationNumber)
    def getSenderId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("senderId", senderId)
    def getSubstitutions: ZIO[Any, AwsError, Map[__string, List[__string]]] =
      AwsError.unwrapOptionField("substitutions", substitutions)
    def getEntityId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("entityId", entityId)
    def getTemplateId: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("templateId", templateId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.SMSMessage
  ) extends zio.aws.pinpoint.model.SMSMessage.ReadOnly {
    override val body: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.body())
      .map(value => value: __string)
    override val keyword: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.keyword())
      .map(value => value: __string)
    override val mediaUrl: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.mediaUrl())
      .map(value => value: __string)
    override val messageType: Optional[zio.aws.pinpoint.model.MessageType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.messageType())
        .map(value => zio.aws.pinpoint.model.MessageType.wrap(value))
    override val originationNumber: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.originationNumber())
      .map(value => value: __string)
    override val senderId: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.senderId())
      .map(value => value: __string)
    override val substitutions: Optional[Map[__string, List[__string]]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.substitutions())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              (key: __string) -> value.asScala.map { item =>
                item: __string
              }.toList
            })
            .toMap
        )
    override val entityId: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.entityId())
      .map(value => value: __string)
    override val templateId: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.templateId())
      .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.SMSMessage
  ): zio.aws.pinpoint.model.SMSMessage.ReadOnly = new Wrapper(impl)
}
