package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpoint.model.primitives.__string
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class SMSMessageActivity(
    messageConfig: Optional[zio.aws.pinpoint.model.JourneySMSMessage] =
      Optional.Absent,
    nextActivity: Optional[__string] = Optional.Absent,
    templateName: Optional[__string] = Optional.Absent,
    templateVersion: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.SMSMessageActivity = {
    import SMSMessageActivity.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.SMSMessageActivity
      .builder()
      .optionallyWith(messageConfig.map(value => value.buildAwsValue()))(
        _.messageConfig
      )
      .optionallyWith(nextActivity.map(value => value: java.lang.String))(
        _.nextActivity
      )
      .optionallyWith(templateName.map(value => value: java.lang.String))(
        _.templateName
      )
      .optionallyWith(templateVersion.map(value => value: java.lang.String))(
        _.templateVersion
      )
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.SMSMessageActivity.ReadOnly =
    zio.aws.pinpoint.model.SMSMessageActivity.wrap(buildAwsValue())
}
object SMSMessageActivity {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.SMSMessageActivity
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.SMSMessageActivity =
      zio.aws.pinpoint.model.SMSMessageActivity(
        messageConfig.map(value => value.asEditable),
        nextActivity.map(value => value),
        templateName.map(value => value),
        templateVersion.map(value => value)
      )
    def messageConfig
        : Optional[zio.aws.pinpoint.model.JourneySMSMessage.ReadOnly]
    def nextActivity: Optional[__string]
    def templateName: Optional[__string]
    def templateVersion: Optional[__string]
    def getMessageConfig: ZIO[
      Any,
      AwsError,
      zio.aws.pinpoint.model.JourneySMSMessage.ReadOnly
    ] = AwsError.unwrapOptionField("messageConfig", messageConfig)
    def getNextActivity: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("nextActivity", nextActivity)
    def getTemplateName: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("templateName", templateName)
    def getTemplateVersion: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("templateVersion", templateVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.SMSMessageActivity
  ) extends zio.aws.pinpoint.model.SMSMessageActivity.ReadOnly {
    override val messageConfig
        : Optional[zio.aws.pinpoint.model.JourneySMSMessage.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.messageConfig())
        .map(value => zio.aws.pinpoint.model.JourneySMSMessage.wrap(value))
    override val nextActivity: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.nextActivity())
      .map(value => value: __string)
    override val templateName: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.templateName())
      .map(value => value: __string)
    override val templateVersion: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.templateVersion())
      .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.SMSMessageActivity
  ): zio.aws.pinpoint.model.SMSMessageActivity.ReadOnly = new Wrapper(impl)
}
