package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpoint.model.primitives.{__boolean, __string}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class Schedule(
    endTime: Optional[__string] = Optional.Absent,
    eventFilter: Optional[zio.aws.pinpoint.model.CampaignEventFilter] =
      Optional.Absent,
    frequency: Optional[zio.aws.pinpoint.model.Frequency] = Optional.Absent,
    isLocalTime: Optional[__boolean] = Optional.Absent,
    quietTime: Optional[zio.aws.pinpoint.model.QuietTime] = Optional.Absent,
    startTime: __string,
    timezone: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.Schedule = {
    import Schedule.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.Schedule
      .builder()
      .optionallyWith(endTime.map(value => value: java.lang.String))(_.endTime)
      .optionallyWith(eventFilter.map(value => value.buildAwsValue()))(
        _.eventFilter
      )
      .optionallyWith(frequency.map(value => value.unwrap))(_.frequency)
      .optionallyWith(isLocalTime.map(value => value: java.lang.Boolean))(
        _.isLocalTime
      )
      .optionallyWith(quietTime.map(value => value.buildAwsValue()))(
        _.quietTime
      )
      .startTime(startTime: java.lang.String)
      .optionallyWith(timezone.map(value => value: java.lang.String))(
        _.timezone
      )
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.Schedule.ReadOnly =
    zio.aws.pinpoint.model.Schedule.wrap(buildAwsValue())
}
object Schedule {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.pinpoint.model.Schedule] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.Schedule =
      zio.aws.pinpoint.model.Schedule(
        endTime.map(value => value),
        eventFilter.map(value => value.asEditable),
        frequency.map(value => value),
        isLocalTime.map(value => value),
        quietTime.map(value => value.asEditable),
        startTime,
        timezone.map(value => value)
      )
    def endTime: Optional[__string]
    def eventFilter
        : Optional[zio.aws.pinpoint.model.CampaignEventFilter.ReadOnly]
    def frequency: Optional[zio.aws.pinpoint.model.Frequency]
    def isLocalTime: Optional[__boolean]
    def quietTime: Optional[zio.aws.pinpoint.model.QuietTime.ReadOnly]
    def startTime: __string
    def timezone: Optional[__string]
    def getEndTime: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("endTime", endTime)
    def getEventFilter: ZIO[
      Any,
      AwsError,
      zio.aws.pinpoint.model.CampaignEventFilter.ReadOnly
    ] = AwsError.unwrapOptionField("eventFilter", eventFilter)
    def getFrequency: ZIO[Any, AwsError, zio.aws.pinpoint.model.Frequency] =
      AwsError.unwrapOptionField("frequency", frequency)
    def getIsLocalTime: ZIO[Any, AwsError, __boolean] =
      AwsError.unwrapOptionField("isLocalTime", isLocalTime)
    def getQuietTime
        : ZIO[Any, AwsError, zio.aws.pinpoint.model.QuietTime.ReadOnly] =
      AwsError.unwrapOptionField("quietTime", quietTime)
    def getStartTime: ZIO[Any, Nothing, __string] = ZIO.succeed(startTime)
    def getTimezone: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("timezone", timezone)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.Schedule
  ) extends zio.aws.pinpoint.model.Schedule.ReadOnly {
    override val endTime: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.endTime())
      .map(value => value: __string)
    override val eventFilter
        : Optional[zio.aws.pinpoint.model.CampaignEventFilter.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.eventFilter())
        .map(value => zio.aws.pinpoint.model.CampaignEventFilter.wrap(value))
    override val frequency: Optional[zio.aws.pinpoint.model.Frequency] =
      zio.aws.core.internal
        .optionalFromNullable(impl.frequency())
        .map(value => zio.aws.pinpoint.model.Frequency.wrap(value))
    override val isLocalTime: Optional[__boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.isLocalTime())
      .map(value => value: __boolean)
    override val quietTime
        : Optional[zio.aws.pinpoint.model.QuietTime.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.quietTime())
        .map(value => zio.aws.pinpoint.model.QuietTime.wrap(value))
    override val startTime: __string = impl.startTime(): __string
    override val timezone: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.timezone())
      .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.Schedule
  ): zio.aws.pinpoint.model.Schedule.ReadOnly = new Wrapper(impl)
}
