package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class SegmentGroupList(
    groups: Optional[Iterable[zio.aws.pinpoint.model.SegmentGroup]] =
      Optional.Absent,
    include: Optional[zio.aws.pinpoint.model.Include] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.SegmentGroupList = {
    import SegmentGroupList.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.SegmentGroupList
      .builder()
      .optionallyWith(
        groups.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.groups)
      .optionallyWith(include.map(value => value.unwrap))(_.include)
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.SegmentGroupList.ReadOnly =
    zio.aws.pinpoint.model.SegmentGroupList.wrap(buildAwsValue())
}
object SegmentGroupList {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.SegmentGroupList
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.SegmentGroupList =
      zio.aws.pinpoint.model.SegmentGroupList(
        groups.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        include.map(value => value)
      )
    def groups: Optional[List[zio.aws.pinpoint.model.SegmentGroup.ReadOnly]]
    def include: Optional[zio.aws.pinpoint.model.Include]
    def getGroups: ZIO[Any, AwsError, List[
      zio.aws.pinpoint.model.SegmentGroup.ReadOnly
    ]] = AwsError.unwrapOptionField("groups", groups)
    def getInclude: ZIO[Any, AwsError, zio.aws.pinpoint.model.Include] =
      AwsError.unwrapOptionField("include", include)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.SegmentGroupList
  ) extends zio.aws.pinpoint.model.SegmentGroupList.ReadOnly {
    override val groups
        : Optional[List[zio.aws.pinpoint.model.SegmentGroup.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.groups())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.pinpoint.model.SegmentGroup.wrap(item)
          }.toList
        )
    override val include: Optional[zio.aws.pinpoint.model.Include] =
      zio.aws.core.internal
        .optionalFromNullable(impl.include())
        .map(value => zio.aws.pinpoint.model.Include.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.SegmentGroupList
  ): zio.aws.pinpoint.model.SegmentGroupList.ReadOnly = new Wrapper(impl)
}
