package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class SegmentLocation(
    country: Optional[zio.aws.pinpoint.model.SetDimension] = Optional.Absent,
    gpsPoint: Optional[zio.aws.pinpoint.model.GPSPointDimension] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.SegmentLocation = {
    import SegmentLocation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.SegmentLocation
      .builder()
      .optionallyWith(country.map(value => value.buildAwsValue()))(_.country)
      .optionallyWith(gpsPoint.map(value => value.buildAwsValue()))(_.gpsPoint)
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.SegmentLocation.ReadOnly =
    zio.aws.pinpoint.model.SegmentLocation.wrap(buildAwsValue())
}
object SegmentLocation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.SegmentLocation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.SegmentLocation =
      zio.aws.pinpoint.model.SegmentLocation(
        country.map(value => value.asEditable),
        gpsPoint.map(value => value.asEditable)
      )
    def country: Optional[zio.aws.pinpoint.model.SetDimension.ReadOnly]
    def gpsPoint: Optional[zio.aws.pinpoint.model.GPSPointDimension.ReadOnly]
    def getCountry
        : ZIO[Any, AwsError, zio.aws.pinpoint.model.SetDimension.ReadOnly] =
      AwsError.unwrapOptionField("country", country)
    def getGpsPoint: ZIO[
      Any,
      AwsError,
      zio.aws.pinpoint.model.GPSPointDimension.ReadOnly
    ] = AwsError.unwrapOptionField("gpsPoint", gpsPoint)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.SegmentLocation
  ) extends zio.aws.pinpoint.model.SegmentLocation.ReadOnly {
    override val country
        : Optional[zio.aws.pinpoint.model.SetDimension.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.country())
        .map(value => zio.aws.pinpoint.model.SetDimension.wrap(value))
    override val gpsPoint
        : Optional[zio.aws.pinpoint.model.GPSPointDimension.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.gpsPoint())
        .map(value => zio.aws.pinpoint.model.GPSPointDimension.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.SegmentLocation
  ): zio.aws.pinpoint.model.SegmentLocation.ReadOnly = new Wrapper(impl)
}
