package zio.aws.pinpoint.model
import zio.prelude.data.Optional
import zio.aws.pinpoint.model.primitives.{__integer, __string}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class SegmentResponse(
    applicationId: __string,
    arn: __string,
    creationDate: __string,
    dimensions: Optional[zio.aws.pinpoint.model.SegmentDimensions] =
      Optional.Absent,
    id: __string,
    importDefinition: Optional[zio.aws.pinpoint.model.SegmentImportResource] =
      Optional.Absent,
    lastModifiedDate: Optional[__string] = Optional.Absent,
    name: Optional[__string] = Optional.Absent,
    segmentGroups: Optional[zio.aws.pinpoint.model.SegmentGroupList] =
      Optional.Absent,
    segmentType: zio.aws.pinpoint.model.SegmentType,
    tags: Optional[Map[__string, __string]] = Optional.Absent,
    version: Optional[__integer] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.SegmentResponse = {
    import SegmentResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.SegmentResponse
      .builder()
      .applicationId(applicationId: java.lang.String)
      .arn(arn: java.lang.String)
      .creationDate(creationDate: java.lang.String)
      .optionallyWith(dimensions.map(value => value.buildAwsValue()))(
        _.dimensions
      )
      .id(id: java.lang.String)
      .optionallyWith(importDefinition.map(value => value.buildAwsValue()))(
        _.importDefinition
      )
      .optionallyWith(lastModifiedDate.map(value => value: java.lang.String))(
        _.lastModifiedDate
      )
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(segmentGroups.map(value => value.buildAwsValue()))(
        _.segmentGroups
      )
      .segmentType(segmentType.unwrap)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(version.map(value => value: Integer))(_.version)
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.SegmentResponse.ReadOnly =
    zio.aws.pinpoint.model.SegmentResponse.wrap(buildAwsValue())
}
object SegmentResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.SegmentResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.SegmentResponse =
      zio.aws.pinpoint.model.SegmentResponse(
        applicationId,
        arn,
        creationDate,
        dimensions.map(value => value.asEditable),
        id,
        importDefinition.map(value => value.asEditable),
        lastModifiedDate.map(value => value),
        name.map(value => value),
        segmentGroups.map(value => value.asEditable),
        segmentType,
        tags.map(value => value),
        version.map(value => value)
      )
    def applicationId: __string
    def arn: __string
    def creationDate: __string
    def dimensions: Optional[zio.aws.pinpoint.model.SegmentDimensions.ReadOnly]
    def id: __string
    def importDefinition
        : Optional[zio.aws.pinpoint.model.SegmentImportResource.ReadOnly]
    def lastModifiedDate: Optional[__string]
    def name: Optional[__string]
    def segmentGroups
        : Optional[zio.aws.pinpoint.model.SegmentGroupList.ReadOnly]
    def segmentType: zio.aws.pinpoint.model.SegmentType
    def tags: Optional[Map[__string, __string]]
    def version: Optional[__integer]
    def getApplicationId: ZIO[Any, Nothing, __string] =
      ZIO.succeed(applicationId)
    def getArn: ZIO[Any, Nothing, __string] = ZIO.succeed(arn)
    def getCreationDate: ZIO[Any, Nothing, __string] = ZIO.succeed(creationDate)
    def getDimensions: ZIO[
      Any,
      AwsError,
      zio.aws.pinpoint.model.SegmentDimensions.ReadOnly
    ] = AwsError.unwrapOptionField("dimensions", dimensions)
    def getId: ZIO[Any, Nothing, __string] = ZIO.succeed(id)
    def getImportDefinition: ZIO[
      Any,
      AwsError,
      zio.aws.pinpoint.model.SegmentImportResource.ReadOnly
    ] = AwsError.unwrapOptionField("importDefinition", importDefinition)
    def getLastModifiedDate: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("lastModifiedDate", lastModifiedDate)
    def getName: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("name", name)
    def getSegmentGroups
        : ZIO[Any, AwsError, zio.aws.pinpoint.model.SegmentGroupList.ReadOnly] =
      AwsError.unwrapOptionField("segmentGroups", segmentGroups)
    def getSegmentType: ZIO[Any, Nothing, zio.aws.pinpoint.model.SegmentType] =
      ZIO.succeed(segmentType)
    def getTags: ZIO[Any, AwsError, Map[__string, __string]] =
      AwsError.unwrapOptionField("tags", tags)
    def getVersion: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField("version", version)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.SegmentResponse
  ) extends zio.aws.pinpoint.model.SegmentResponse.ReadOnly {
    override val applicationId: __string = impl.applicationId(): __string
    override val arn: __string = impl.arn(): __string
    override val creationDate: __string = impl.creationDate(): __string
    override val dimensions
        : Optional[zio.aws.pinpoint.model.SegmentDimensions.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dimensions())
        .map(value => zio.aws.pinpoint.model.SegmentDimensions.wrap(value))
    override val id: __string = impl.id(): __string
    override val importDefinition
        : Optional[zio.aws.pinpoint.model.SegmentImportResource.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.importDefinition())
        .map(value => zio.aws.pinpoint.model.SegmentImportResource.wrap(value))
    override val lastModifiedDate: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.lastModifiedDate())
      .map(value => value: __string)
    override val name: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => value: __string)
    override val segmentGroups
        : Optional[zio.aws.pinpoint.model.SegmentGroupList.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.segmentGroups())
        .map(value => zio.aws.pinpoint.model.SegmentGroupList.wrap(value))
    override val segmentType: zio.aws.pinpoint.model.SegmentType =
      zio.aws.pinpoint.model.SegmentType.wrap(impl.segmentType())
    override val tags: Optional[Map[__string, __string]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: __string) -> (value: __string)
          })
          .toMap
      )
    override val version: Optional[__integer] = zio.aws.core.internal
      .optionalFromNullable(impl.version())
      .map(value => value: __integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.SegmentResponse
  ): zio.aws.pinpoint.model.SegmentResponse.ReadOnly = new Wrapper(impl)
}
