package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class SendMessagesResponse(
    messageResponse: zio.aws.pinpoint.model.MessageResponse
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.SendMessagesResponse = {
    import SendMessagesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.SendMessagesResponse
      .builder()
      .messageResponse(messageResponse.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.SendMessagesResponse.ReadOnly =
    zio.aws.pinpoint.model.SendMessagesResponse.wrap(buildAwsValue())
}
object SendMessagesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.SendMessagesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.SendMessagesResponse =
      zio.aws.pinpoint.model.SendMessagesResponse(messageResponse.asEditable)
    def messageResponse: zio.aws.pinpoint.model.MessageResponse.ReadOnly
    def getMessageResponse
        : ZIO[Any, Nothing, zio.aws.pinpoint.model.MessageResponse.ReadOnly] =
      ZIO.succeed(messageResponse)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.SendMessagesResponse
  ) extends zio.aws.pinpoint.model.SendMessagesResponse.ReadOnly {
    override val messageResponse
        : zio.aws.pinpoint.model.MessageResponse.ReadOnly =
      zio.aws.pinpoint.model.MessageResponse.wrap(impl.messageResponse())
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.SendMessagesResponse
  ): zio.aws.pinpoint.model.SendMessagesResponse.ReadOnly = new Wrapper(impl)
}
