package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpoint.model.primitives.__string
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class StartCondition(
    description: Optional[__string] = Optional.Absent,
    eventStartCondition: Optional[zio.aws.pinpoint.model.EventStartCondition] =
      Optional.Absent,
    segmentStartCondition: Optional[zio.aws.pinpoint.model.SegmentCondition] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.StartCondition = {
    import StartCondition.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.StartCondition
      .builder()
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(eventStartCondition.map(value => value.buildAwsValue()))(
        _.eventStartCondition
      )
      .optionallyWith(
        segmentStartCondition.map(value => value.buildAwsValue())
      )(_.segmentStartCondition)
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.StartCondition.ReadOnly =
    zio.aws.pinpoint.model.StartCondition.wrap(buildAwsValue())
}
object StartCondition {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.StartCondition
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.StartCondition =
      zio.aws.pinpoint.model.StartCondition(
        description.map(value => value),
        eventStartCondition.map(value => value.asEditable),
        segmentStartCondition.map(value => value.asEditable)
      )
    def description: Optional[__string]
    def eventStartCondition
        : Optional[zio.aws.pinpoint.model.EventStartCondition.ReadOnly]
    def segmentStartCondition
        : Optional[zio.aws.pinpoint.model.SegmentCondition.ReadOnly]
    def getDescription: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("description", description)
    def getEventStartCondition: ZIO[
      Any,
      AwsError,
      zio.aws.pinpoint.model.EventStartCondition.ReadOnly
    ] = AwsError.unwrapOptionField("eventStartCondition", eventStartCondition)
    def getSegmentStartCondition
        : ZIO[Any, AwsError, zio.aws.pinpoint.model.SegmentCondition.ReadOnly] =
      AwsError.unwrapOptionField("segmentStartCondition", segmentStartCondition)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.StartCondition
  ) extends zio.aws.pinpoint.model.StartCondition.ReadOnly {
    override val description: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: __string)
    override val eventStartCondition
        : Optional[zio.aws.pinpoint.model.EventStartCondition.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.eventStartCondition())
        .map(value => zio.aws.pinpoint.model.EventStartCondition.wrap(value))
    override val segmentStartCondition
        : Optional[zio.aws.pinpoint.model.SegmentCondition.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.segmentStartCondition())
        .map(value => zio.aws.pinpoint.model.SegmentCondition.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.StartCondition
  ): zio.aws.pinpoint.model.StartCondition.ReadOnly = new Wrapper(impl)
}
