package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpoint.model.primitives.__string
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class Template(
    name: Optional[__string] = Optional.Absent,
    version: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.Template = {
    import Template.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.Template
      .builder()
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(version.map(value => value: java.lang.String))(_.version)
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.Template.ReadOnly =
    zio.aws.pinpoint.model.Template.wrap(buildAwsValue())
}
object Template {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.pinpoint.model.Template] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.Template = zio.aws.pinpoint.model
      .Template(name.map(value => value), version.map(value => value))
    def name: Optional[__string]
    def version: Optional[__string]
    def getName: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("name", name)
    def getVersion: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("version", version)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.Template
  ) extends zio.aws.pinpoint.model.Template.ReadOnly {
    override val name: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => value: __string)
    override val version: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.version())
      .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.Template
  ): zio.aws.pinpoint.model.Template.ReadOnly = new Wrapper(impl)
}
