package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class TemplateConfiguration(
    emailTemplate: Optional[zio.aws.pinpoint.model.Template] = Optional.Absent,
    pushTemplate: Optional[zio.aws.pinpoint.model.Template] = Optional.Absent,
    smsTemplate: Optional[zio.aws.pinpoint.model.Template] = Optional.Absent,
    voiceTemplate: Optional[zio.aws.pinpoint.model.Template] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.TemplateConfiguration = {
    import TemplateConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.TemplateConfiguration
      .builder()
      .optionallyWith(emailTemplate.map(value => value.buildAwsValue()))(
        _.emailTemplate
      )
      .optionallyWith(pushTemplate.map(value => value.buildAwsValue()))(
        _.pushTemplate
      )
      .optionallyWith(smsTemplate.map(value => value.buildAwsValue()))(
        _.smsTemplate
      )
      .optionallyWith(voiceTemplate.map(value => value.buildAwsValue()))(
        _.voiceTemplate
      )
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.TemplateConfiguration.ReadOnly =
    zio.aws.pinpoint.model.TemplateConfiguration.wrap(buildAwsValue())
}
object TemplateConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.TemplateConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.TemplateConfiguration =
      zio.aws.pinpoint.model.TemplateConfiguration(
        emailTemplate.map(value => value.asEditable),
        pushTemplate.map(value => value.asEditable),
        smsTemplate.map(value => value.asEditable),
        voiceTemplate.map(value => value.asEditable)
      )
    def emailTemplate: Optional[zio.aws.pinpoint.model.Template.ReadOnly]
    def pushTemplate: Optional[zio.aws.pinpoint.model.Template.ReadOnly]
    def smsTemplate: Optional[zio.aws.pinpoint.model.Template.ReadOnly]
    def voiceTemplate: Optional[zio.aws.pinpoint.model.Template.ReadOnly]
    def getEmailTemplate
        : ZIO[Any, AwsError, zio.aws.pinpoint.model.Template.ReadOnly] =
      AwsError.unwrapOptionField("emailTemplate", emailTemplate)
    def getPushTemplate
        : ZIO[Any, AwsError, zio.aws.pinpoint.model.Template.ReadOnly] =
      AwsError.unwrapOptionField("pushTemplate", pushTemplate)
    def getSmsTemplate
        : ZIO[Any, AwsError, zio.aws.pinpoint.model.Template.ReadOnly] =
      AwsError.unwrapOptionField("smsTemplate", smsTemplate)
    def getVoiceTemplate
        : ZIO[Any, AwsError, zio.aws.pinpoint.model.Template.ReadOnly] =
      AwsError.unwrapOptionField("voiceTemplate", voiceTemplate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.TemplateConfiguration
  ) extends zio.aws.pinpoint.model.TemplateConfiguration.ReadOnly {
    override val emailTemplate
        : Optional[zio.aws.pinpoint.model.Template.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.emailTemplate())
        .map(value => zio.aws.pinpoint.model.Template.wrap(value))
    override val pushTemplate
        : Optional[zio.aws.pinpoint.model.Template.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.pushTemplate())
        .map(value => zio.aws.pinpoint.model.Template.wrap(value))
    override val smsTemplate
        : Optional[zio.aws.pinpoint.model.Template.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.smsTemplate())
        .map(value => zio.aws.pinpoint.model.Template.wrap(value))
    override val voiceTemplate
        : Optional[zio.aws.pinpoint.model.Template.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.voiceTemplate())
        .map(value => zio.aws.pinpoint.model.Template.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.TemplateConfiguration
  ): zio.aws.pinpoint.model.TemplateConfiguration.ReadOnly = new Wrapper(impl)
}
