package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpoint.model.primitives.__string
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class TemplateCreateMessageBody(
    arn: Optional[__string] = Optional.Absent,
    message: Optional[__string] = Optional.Absent,
    requestID: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.TemplateCreateMessageBody = {
    import TemplateCreateMessageBody.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.TemplateCreateMessageBody
      .builder()
      .optionallyWith(arn.map(value => value: java.lang.String))(_.arn)
      .optionallyWith(message.map(value => value: java.lang.String))(_.message)
      .optionallyWith(requestID.map(value => value: java.lang.String))(
        _.requestID
      )
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.TemplateCreateMessageBody.ReadOnly =
    zio.aws.pinpoint.model.TemplateCreateMessageBody.wrap(buildAwsValue())
}
object TemplateCreateMessageBody {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.TemplateCreateMessageBody
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.TemplateCreateMessageBody =
      zio.aws.pinpoint.model.TemplateCreateMessageBody(
        arn.map(value => value),
        message.map(value => value),
        requestID.map(value => value)
      )
    def arn: Optional[__string]
    def message: Optional[__string]
    def requestID: Optional[__string]
    def getArn: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("arn", arn)
    def getMessage: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("message", message)
    def getRequestID: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("requestID", requestID)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.TemplateCreateMessageBody
  ) extends zio.aws.pinpoint.model.TemplateCreateMessageBody.ReadOnly {
    override val arn: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => value: __string)
    override val message: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.message())
      .map(value => value: __string)
    override val requestID: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.requestID())
      .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.TemplateCreateMessageBody
  ): zio.aws.pinpoint.model.TemplateCreateMessageBody.ReadOnly = new Wrapper(
    impl
  )
}
