package zio.aws.pinpoint.model
import scala.jdk.CollectionConverters.*
sealed trait TemplateType {
  def unwrap: software.amazon.awssdk.services.pinpoint.model.TemplateType
}
object TemplateType {
  def wrap(
      value: software.amazon.awssdk.services.pinpoint.model.TemplateType
  ): zio.aws.pinpoint.model.TemplateType = value match {
    case software.amazon.awssdk.services.pinpoint.model.TemplateType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.pinpoint.model.TemplateType.EMAIL =>
      val r = EMAIL
      r
    case software.amazon.awssdk.services.pinpoint.model.TemplateType.SMS =>
      val r = SMS
      r
    case software.amazon.awssdk.services.pinpoint.model.TemplateType.VOICE =>
      val r = VOICE
      r
    case software.amazon.awssdk.services.pinpoint.model.TemplateType.PUSH =>
      val r = PUSH
      r
    case software.amazon.awssdk.services.pinpoint.model.TemplateType.INAPP =>
      val r = INAPP
      r
  }
  case object unknownToSdkVersion extends zio.aws.pinpoint.model.TemplateType {
    override def unwrap
        : software.amazon.awssdk.services.pinpoint.model.TemplateType =
      software.amazon.awssdk.services.pinpoint.model.TemplateType.UNKNOWN_TO_SDK_VERSION
  }
  case object EMAIL extends zio.aws.pinpoint.model.TemplateType {
    override def unwrap
        : software.amazon.awssdk.services.pinpoint.model.TemplateType =
      software.amazon.awssdk.services.pinpoint.model.TemplateType.EMAIL
  }
  case object SMS extends zio.aws.pinpoint.model.TemplateType {
    override def unwrap
        : software.amazon.awssdk.services.pinpoint.model.TemplateType =
      software.amazon.awssdk.services.pinpoint.model.TemplateType.SMS
  }
  case object VOICE extends zio.aws.pinpoint.model.TemplateType {
    override def unwrap
        : software.amazon.awssdk.services.pinpoint.model.TemplateType =
      software.amazon.awssdk.services.pinpoint.model.TemplateType.VOICE
  }
  case object PUSH extends zio.aws.pinpoint.model.TemplateType {
    override def unwrap
        : software.amazon.awssdk.services.pinpoint.model.TemplateType =
      software.amazon.awssdk.services.pinpoint.model.TemplateType.PUSH
  }
  case object INAPP extends zio.aws.pinpoint.model.TemplateType {
    override def unwrap
        : software.amazon.awssdk.services.pinpoint.model.TemplateType =
      software.amazon.awssdk.services.pinpoint.model.TemplateType.INAPP
  }
}
