package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpoint.model.primitives.__string
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class TemplateVersionsResponse(
    item: Iterable[zio.aws.pinpoint.model.TemplateVersionResponse],
    message: Optional[__string] = Optional.Absent,
    nextToken: Optional[__string] = Optional.Absent,
    requestID: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.TemplateVersionsResponse = {
    import TemplateVersionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.TemplateVersionsResponse
      .builder()
      .item(item.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(message.map(value => value: java.lang.String))(_.message)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(requestID.map(value => value: java.lang.String))(
        _.requestID
      )
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.TemplateVersionsResponse.ReadOnly =
    zio.aws.pinpoint.model.TemplateVersionsResponse.wrap(buildAwsValue())
}
object TemplateVersionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.TemplateVersionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.TemplateVersionsResponse =
      zio.aws.pinpoint.model.TemplateVersionsResponse(
        item.map { item =>
          item.asEditable
        },
        message.map(value => value),
        nextToken.map(value => value),
        requestID.map(value => value)
      )
    def item: List[zio.aws.pinpoint.model.TemplateVersionResponse.ReadOnly]
    def message: Optional[__string]
    def nextToken: Optional[__string]
    def requestID: Optional[__string]
    def getItem: ZIO[Any, Nothing, List[
      zio.aws.pinpoint.model.TemplateVersionResponse.ReadOnly
    ]] = ZIO.succeed(item)
    def getMessage: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("message", message)
    def getNextToken: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getRequestID: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("requestID", requestID)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.TemplateVersionsResponse
  ) extends zio.aws.pinpoint.model.TemplateVersionsResponse.ReadOnly {
    override val item
        : List[zio.aws.pinpoint.model.TemplateVersionResponse.ReadOnly] = impl
      .item()
      .asScala
      .map { item =>
        zio.aws.pinpoint.model.TemplateVersionResponse.wrap(item)
      }
      .toList
    override val message: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.message())
      .map(value => value: __string)
    override val nextToken: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: __string)
    override val requestID: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.requestID())
      .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.TemplateVersionsResponse
  ): zio.aws.pinpoint.model.TemplateVersionsResponse.ReadOnly = new Wrapper(
    impl
  )
}
