package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.pinpoint.model.primitives.__string
import scala.jdk.CollectionConverters.*
final case class UpdateAdmChannelRequest(
    admChannelRequest: zio.aws.pinpoint.model.ADMChannelRequest,
    applicationId: __string
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.UpdateAdmChannelRequest = {
    import UpdateAdmChannelRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.UpdateAdmChannelRequest
      .builder()
      .admChannelRequest(admChannelRequest.buildAwsValue())
      .applicationId(applicationId: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.UpdateAdmChannelRequest.ReadOnly =
    zio.aws.pinpoint.model.UpdateAdmChannelRequest.wrap(buildAwsValue())
}
object UpdateAdmChannelRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.UpdateAdmChannelRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.UpdateAdmChannelRequest =
      zio.aws.pinpoint.model
        .UpdateAdmChannelRequest(admChannelRequest.asEditable, applicationId)
    def admChannelRequest: zio.aws.pinpoint.model.ADMChannelRequest.ReadOnly
    def applicationId: __string
    def getAdmChannelRequest
        : ZIO[Any, Nothing, zio.aws.pinpoint.model.ADMChannelRequest.ReadOnly] =
      ZIO.succeed(admChannelRequest)
    def getApplicationId: ZIO[Any, Nothing, __string] =
      ZIO.succeed(applicationId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.UpdateAdmChannelRequest
  ) extends zio.aws.pinpoint.model.UpdateAdmChannelRequest.ReadOnly {
    override val admChannelRequest
        : zio.aws.pinpoint.model.ADMChannelRequest.ReadOnly =
      zio.aws.pinpoint.model.ADMChannelRequest.wrap(impl.admChannelRequest())
    override val applicationId: __string = impl.applicationId(): __string
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.UpdateAdmChannelRequest
  ): zio.aws.pinpoint.model.UpdateAdmChannelRequest.ReadOnly = new Wrapper(impl)
}
