package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.pinpoint.model.primitives.__string
import scala.jdk.CollectionConverters.*
final case class UpdateApnsChannelRequest(
    apnsChannelRequest: zio.aws.pinpoint.model.APNSChannelRequest,
    applicationId: __string
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.UpdateApnsChannelRequest = {
    import UpdateApnsChannelRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.UpdateApnsChannelRequest
      .builder()
      .apnsChannelRequest(apnsChannelRequest.buildAwsValue())
      .applicationId(applicationId: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.UpdateApnsChannelRequest.ReadOnly =
    zio.aws.pinpoint.model.UpdateApnsChannelRequest.wrap(buildAwsValue())
}
object UpdateApnsChannelRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.UpdateApnsChannelRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.UpdateApnsChannelRequest =
      zio.aws.pinpoint.model
        .UpdateApnsChannelRequest(apnsChannelRequest.asEditable, applicationId)
    def apnsChannelRequest: zio.aws.pinpoint.model.APNSChannelRequest.ReadOnly
    def applicationId: __string
    def getApnsChannelRequest: ZIO[
      Any,
      Nothing,
      zio.aws.pinpoint.model.APNSChannelRequest.ReadOnly
    ] = ZIO.succeed(apnsChannelRequest)
    def getApplicationId: ZIO[Any, Nothing, __string] =
      ZIO.succeed(applicationId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.UpdateApnsChannelRequest
  ) extends zio.aws.pinpoint.model.UpdateApnsChannelRequest.ReadOnly {
    override val apnsChannelRequest
        : zio.aws.pinpoint.model.APNSChannelRequest.ReadOnly =
      zio.aws.pinpoint.model.APNSChannelRequest.wrap(impl.apnsChannelRequest())
    override val applicationId: __string = impl.applicationId(): __string
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.UpdateApnsChannelRequest
  ): zio.aws.pinpoint.model.UpdateApnsChannelRequest.ReadOnly = new Wrapper(
    impl
  )
}
