package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.pinpoint.model.primitives.__string
import scala.jdk.CollectionConverters.*
final case class UpdateApnsVoipChannelRequest(
    apnsVoipChannelRequest: zio.aws.pinpoint.model.APNSVoipChannelRequest,
    applicationId: __string
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.UpdateApnsVoipChannelRequest = {
    import UpdateApnsVoipChannelRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.UpdateApnsVoipChannelRequest
      .builder()
      .apnsVoipChannelRequest(apnsVoipChannelRequest.buildAwsValue())
      .applicationId(applicationId: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.UpdateApnsVoipChannelRequest.ReadOnly =
    zio.aws.pinpoint.model.UpdateApnsVoipChannelRequest.wrap(buildAwsValue())
}
object UpdateApnsVoipChannelRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.UpdateApnsVoipChannelRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.UpdateApnsVoipChannelRequest =
      zio.aws.pinpoint.model.UpdateApnsVoipChannelRequest(
        apnsVoipChannelRequest.asEditable,
        applicationId
      )
    def apnsVoipChannelRequest
        : zio.aws.pinpoint.model.APNSVoipChannelRequest.ReadOnly
    def applicationId: __string
    def getApnsVoipChannelRequest: ZIO[
      Any,
      Nothing,
      zio.aws.pinpoint.model.APNSVoipChannelRequest.ReadOnly
    ] = ZIO.succeed(apnsVoipChannelRequest)
    def getApplicationId: ZIO[Any, Nothing, __string] =
      ZIO.succeed(applicationId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.UpdateApnsVoipChannelRequest
  ) extends zio.aws.pinpoint.model.UpdateApnsVoipChannelRequest.ReadOnly {
    override val apnsVoipChannelRequest
        : zio.aws.pinpoint.model.APNSVoipChannelRequest.ReadOnly =
      zio.aws.pinpoint.model.APNSVoipChannelRequest
        .wrap(impl.apnsVoipChannelRequest())
    override val applicationId: __string = impl.applicationId(): __string
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.UpdateApnsVoipChannelRequest
  ): zio.aws.pinpoint.model.UpdateApnsVoipChannelRequest.ReadOnly = new Wrapper(
    impl
  )
}
