package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpoint.model.primitives.__string
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateAttributesRequest(
    blacklist: Optional[Iterable[__string]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.UpdateAttributesRequest = {
    import UpdateAttributesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.UpdateAttributesRequest
      .builder()
      .optionallyWith(
        blacklist.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.blacklist)
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.UpdateAttributesRequest.ReadOnly =
    zio.aws.pinpoint.model.UpdateAttributesRequest.wrap(buildAwsValue())
}
object UpdateAttributesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.UpdateAttributesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.UpdateAttributesRequest =
      zio.aws.pinpoint.model
        .UpdateAttributesRequest(blacklist.map(value => value))
    def blacklist: Optional[List[__string]]
    def getBlacklist: ZIO[Any, AwsError, List[__string]] =
      AwsError.unwrapOptionField("blacklist", blacklist)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.UpdateAttributesRequest
  ) extends zio.aws.pinpoint.model.UpdateAttributesRequest.ReadOnly {
    override val blacklist: Optional[List[__string]] = zio.aws.core.internal
      .optionalFromNullable(impl.blacklist())
      .map(value =>
        value.asScala.map { item =>
          item: __string
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.UpdateAttributesRequest
  ): zio.aws.pinpoint.model.UpdateAttributesRequest.ReadOnly = new Wrapper(impl)
}
