package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.pinpoint.model.primitives.__string
import scala.jdk.CollectionConverters.*
final case class UpdateEndpointRequest(
    applicationId: __string,
    endpointId: __string,
    endpointRequest: zio.aws.pinpoint.model.EndpointRequest
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.UpdateEndpointRequest = {
    import UpdateEndpointRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.UpdateEndpointRequest
      .builder()
      .applicationId(applicationId: java.lang.String)
      .endpointId(endpointId: java.lang.String)
      .endpointRequest(endpointRequest.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.UpdateEndpointRequest.ReadOnly =
    zio.aws.pinpoint.model.UpdateEndpointRequest.wrap(buildAwsValue())
}
object UpdateEndpointRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.UpdateEndpointRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.UpdateEndpointRequest =
      zio.aws.pinpoint.model.UpdateEndpointRequest(
        applicationId,
        endpointId,
        endpointRequest.asEditable
      )
    def applicationId: __string
    def endpointId: __string
    def endpointRequest: zio.aws.pinpoint.model.EndpointRequest.ReadOnly
    def getApplicationId: ZIO[Any, Nothing, __string] =
      ZIO.succeed(applicationId)
    def getEndpointId: ZIO[Any, Nothing, __string] = ZIO.succeed(endpointId)
    def getEndpointRequest
        : ZIO[Any, Nothing, zio.aws.pinpoint.model.EndpointRequest.ReadOnly] =
      ZIO.succeed(endpointRequest)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.UpdateEndpointRequest
  ) extends zio.aws.pinpoint.model.UpdateEndpointRequest.ReadOnly {
    override val applicationId: __string = impl.applicationId(): __string
    override val endpointId: __string = impl.endpointId(): __string
    override val endpointRequest
        : zio.aws.pinpoint.model.EndpointRequest.ReadOnly =
      zio.aws.pinpoint.model.EndpointRequest.wrap(impl.endpointRequest())
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.UpdateEndpointRequest
  ): zio.aws.pinpoint.model.UpdateEndpointRequest.ReadOnly = new Wrapper(impl)
}
