package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class UpdateJourneyResponse(
    journeyResponse: zio.aws.pinpoint.model.JourneyResponse
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.UpdateJourneyResponse = {
    import UpdateJourneyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.UpdateJourneyResponse
      .builder()
      .journeyResponse(journeyResponse.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.UpdateJourneyResponse.ReadOnly =
    zio.aws.pinpoint.model.UpdateJourneyResponse.wrap(buildAwsValue())
}
object UpdateJourneyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.UpdateJourneyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.UpdateJourneyResponse =
      zio.aws.pinpoint.model.UpdateJourneyResponse(journeyResponse.asEditable)
    def journeyResponse: zio.aws.pinpoint.model.JourneyResponse.ReadOnly
    def getJourneyResponse
        : ZIO[Any, Nothing, zio.aws.pinpoint.model.JourneyResponse.ReadOnly] =
      ZIO.succeed(journeyResponse)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.UpdateJourneyResponse
  ) extends zio.aws.pinpoint.model.UpdateJourneyResponse.ReadOnly {
    override val journeyResponse
        : zio.aws.pinpoint.model.JourneyResponse.ReadOnly =
      zio.aws.pinpoint.model.JourneyResponse.wrap(impl.journeyResponse())
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.UpdateJourneyResponse
  ): zio.aws.pinpoint.model.UpdateJourneyResponse.ReadOnly = new Wrapper(impl)
}
