package zio.aws.pinpoint.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class UpdateJourneyStateResponse(
    journeyResponse: zio.aws.pinpoint.model.JourneyResponse
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpoint.model.UpdateJourneyStateResponse = {
    import UpdateJourneyStateResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpoint.model.UpdateJourneyStateResponse
      .builder()
      .journeyResponse(journeyResponse.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.pinpoint.model.UpdateJourneyStateResponse.ReadOnly =
    zio.aws.pinpoint.model.UpdateJourneyStateResponse.wrap(buildAwsValue())
}
object UpdateJourneyStateResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpoint.model.UpdateJourneyStateResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpoint.model.UpdateJourneyStateResponse =
      zio.aws.pinpoint.model
        .UpdateJourneyStateResponse(journeyResponse.asEditable)
    def journeyResponse: zio.aws.pinpoint.model.JourneyResponse.ReadOnly
    def getJourneyResponse
        : ZIO[Any, Nothing, zio.aws.pinpoint.model.JourneyResponse.ReadOnly] =
      ZIO.succeed(journeyResponse)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpoint.model.UpdateJourneyStateResponse
  ) extends zio.aws.pinpoint.model.UpdateJourneyStateResponse.ReadOnly {
    override val journeyResponse
        : zio.aws.pinpoint.model.JourneyResponse.ReadOnly =
      zio.aws.pinpoint.model.JourneyResponse.wrap(impl.journeyResponse())
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpoint.model.UpdateJourneyStateResponse
  ): zio.aws.pinpoint.model.UpdateJourneyStateResponse.ReadOnly = new Wrapper(
    impl
  )
}
